
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="black_beans")


    # Set objective function
    m.setObjective(3*x0 + 8*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5*x0 + 16*x1 >= 12, "umami_min")
    m.addConstr(8*x0 + 12*x1 >= 11, "iron_min")
    m.addConstr(-4*x0 + 10*x1 >= 0, "pasta_beans_ratio")
    m.addConstr(5*x0 + 16*x1 <= 57, "umami_max")
    m.addConstr(8*x0 + 12*x1 <= 27, "iron_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')

