
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="bowls_of_pasta")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="black_beans")

# Set the objective function
m.setObjective(3*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 16*x2 >= 12, name="umami_index_lower_bound")
m.addConstr(8*x1 + 12*x2 >= 11, name="iron_content_lower_bound")
m.addConstr(-4*x1 + 10*x2 >= 0, name="linear_combination_constraint")
m.addConstr(5*x1 + 16*x2 <= 57, name="umami_index_upper_bound")
m.addConstr(8*x1 + 12*x2 <= 27, name="iron_content_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_pasta: {x1.x}")
    print(f"black_beans: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
