
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='bowls_of_pasta', lb=0)  # bowls of pasta
    x2 = model.addVar(name='black_beans', lb=0)  # black beans

    # Define the objective function
    model.setObjective(3 * x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(5 * x1 + 16 * x2 >= 12, name='umami_index_constraint')
    model.addConstr(8 * x1 + 12 * x2 >= 11, name='iron_constraint')
    model.addConstr(-4 * x1 + 10 * x2 >= 0, name='linear_combination_constraint')
    model.addConstr(5 * x1 + 16 * x2 <= 57, name='umami_index_upper_bound')
    model.addConstr(8 * x1 + 12 * x2 <= 27, name='iron_upper_bound')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'bowls of pasta: {x1.varValue}')
        print(f'black beans: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
