
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # lemons
    x1 = model.addVar(name="x1", lb=0)  # eggs
    x2 = model.addVar(name="x2", lb=0)  # bagged salads
    x3 = model.addVar(name="x3", lb=0)  # tomatoes

    # Define the objective function
    model.setObjective(5 * x0 + 3 * x1 + 4 * x2 + 6 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14 * x0 + 4 * x1 + 15 * x2 + 13 * x3 >= 19)
    model.addConstr(4 * x1 + 13 * x3 >= 33)
    model.addConstr(11 * x0 + 5 * x1 + 4 * x3 >= 37)
    model.addConstr(2 * x0 + 12 * x3 >= 24)
    model.addConstr(2 * x0 + 8 * x1 >= 34)
    model.addConstr(2 * x0 + 8 * x1 + 15 * x2 >= 27)
    model.addConstr(8 * x1 + 15 * x2 + 12 * x3 >= 27)
    model.addConstr(2 * x0 + 8 * x1 + 12 * x3 >= 27)
    model.addConstr(2 * x0 + 8 * x1 + 15 * x2 >= 35)
    model.addConstr(8 * x1 + 15 * x2 + 12 * x3 >= 35)
    model.addConstr(2 * x0 + 8 * x1 + 12 * x3 >= 35)
    model.addConstr(2 * x0 + 8 * x1 + 15 * x2 >= 31)
    model.addConstr(8 * x1 + 15 * x2 + 12 * x3 >= 31)
    model.addConstr(2 * x0 + 8 * x1 + 12 * x3 >= 31)
    model.addConstr(4 * x1 + 13 * x3 <= 86)
    model.addConstr(14 * x0 + 4 * x1 + 15 * x2 <= 75)
    model.addConstr(14 * x0 + 4 * x1 + 15 * x2 + 13 * x3 <= 75)
    model.addConstr(11 * x0 + 5 * x2 <= 100)
    model.addConstr(5 * x1 + 4 * x3 <= 85)
    model.addConstr(5 * x2 + 4 * x3 <= 104)
    model.addConstr(5 * x1 + 5 * x2 <= 47)
    model.addConstr(11 * x0 + 5 * x1 + 5 * x2 + 4 * x3 <= 47)
    model.addConstr(15 * x2 + 12 * x3 <= 81)
    model.addConstr(2 * x0 + 12 * x3 <= 102)
    model.addConstr(8 * x1 + 15 * x2 + 12 * x3 <= 142)
    model.addConstr(2 * x0 + 8 * x1 + 12 * x3 <= 147)
    model.addConstr(2 * x0 + 8 * x1 + 15 * x2 + 12 * x3 <= 147)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0 (lemons): ", x0.varValue)
        print("x1 (eggs): ", x1.varValue)
        print("x2 (bagged salads): ", x2.varValue)
        print("x3 (tomatoes): ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
