
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
x1 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
x2 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Set the objective function
m.setObjective(7.19*x0*x1 + 1.57*x0*x2 + 2.02*x1**2 + 3.09*x0 + 7.49*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(11.44*x0 + 11.11*x1 + 14.9*x2 <= 84)
m.addConstr(12.65*x0 + 0.78*x1 + 14.19*x2 <= 155)
m.addConstr(11.44*x0 + 14.9*x2 <= 65)
m.addConstr(12.65*x0 + 14.19*x2 <= 69)
m.addConstr(0.78*x1 + 14.19*x2 <= 105)
m.addConstr(12.65*x0 + 0.78*x1 <= 107)
m.addConstr(12.65*x0 + 0.78*x1 + 14.19*x2 <= 131)

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
