
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="patches_per_day", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)

    # Define objective function
    model.setObjective(7.19 * x1 * x2 + 1.57 * x1 * x3 + 2.02 * x2**2 + 3.09 * x1 + 7.49 * x2, gurobi.GRB.MAXIMIZE)

    # Define constraints
    model.addConstr(11.44 * x1 + 11.11 * x2 + 14.9 * x3 <= 84)
    model.addConstr(12.65 * x1 + 0.78 * x2 + 14.19 * x3 <= 155)
    model.addConstr(11.44 * x1 + 14.9 * x3 <= 65)
    model.addConstr(12.65 * x1 + 14.19 * x3 <= 69)
    model.addConstr(0.78 * x2 + 14.19 * x3 <= 105)
    model.addConstr(12.65 * x1 + 0.78 * x2 <= 107)
    model.addConstr(12.65 * x1 + 0.78 * x2 + 14.19 * x3 <= 131)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Patches per day: ", x1.varValue)
        print("Pen testers: ", x2.varValue)
        print("Intrusion analysts: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
