
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("organization_score_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Peggy
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Paul
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # hours worked by Bill


    # Set objective function
    m.setObjective(8.96 * x0 + 1.78 * x1 + 9.49 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20 * x0 + 17 * x1 >= 38, "c1")
    m.addConstr(20 * x0 + 4 * x2 >= 35, "c2")
    m.addConstr(17 * x1 + 4 * x2 >= 50, "c3")
    m.addConstr(20 * x0 + 17 * x1 + 4 * x2 >= 83, "c4")
    m.addConstr(17 * x1 + 4 * x2 <= 198, "c5")
    m.addConstr(20 * x0 + 17 * x1 <= 166, "c6")
    m.addConstr(20 * x0 + 17 * x1 + 4 * x2 <= 166, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
