
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name='hours_worked_by_Peggy')
x2 = m.addVar(name='hours_worked_by_Paul')
x3 = m.addVar(name='hours_worked_by_Bill')

# Set the objective function
m.setObjective(8.96*x1 + 1.78*x2 + 9.49*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 17*x2 >= 38, name='Peggy_and_Paul_min_score')
m.addConstr(20*x1 + 4*x3 >= 35, name='Peggy_and_Bill_min_score')
m.addConstr(17*x2 + 4*x3 >= 50, name='Paul_and_Bill_min_score')
m.addConstr(20*x1 + 17*x2 + 4*x3 >= 83, name='Total_min_score')
m.addConstr(17*x2 + 4*x3 <= 198, name='Paul_and_Bill_max_score')
m.addConstr(20*x1 + 17*x2 <= 166, name='Peggy_and_Paul_max_score')
m.addConstr(20*x1 + 17*x2 + 4*x3 <= 166, name='Total_max_score')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f'Hours worked by Peggy: {x1.x}')
    print(f'Hours worked by Paul: {x2.x}')
    print(f'Hours worked by Bill: {x3.x}')
else:
    print("No optimal solution found")
