
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Peggy", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Paul", lb=0)   # Assuming hours cannot be negative
    x3 = model.addVar(name="hours_worked_by_Bill", lb=0)   # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(8.96 * x1 + 1.78 * x2 + 9.49 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(20 * x1 + 17 * x2 >= 38)
    model.addConstr(20 * x1 + 4 * x3 >= 35)
    model.addConstr(17 * x2 + 4 * x3 >= 50)
    model.addConstr(20 * x1 + 17 * x2 + 4 * x3 >= 83)
    model.addConstr(17 * x2 + 4 * x3 <= 198)
    model.addConstr(20 * x1 + 17 * x2 <= 166)
    model.addConstr(20 * x1 + 17 * x2 + 4 * x3 <= 166)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {x1.varValue}")
        print(f"Hours worked by Paul: {x2.varValue}")
        print(f"Hours worked by Bill: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
