
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(7, lb=0, name=["Mary", "Dale", "John", "Paul", "George", "Laura", "Peggy"])


# Set objective
obj = 4.29 * x[0] + 6.96 * x[1] + 1.97 * x[2] + 6.01 * x[3] + 8.03 * x[4] + 8.83 * x[5] + 3.7 * x[6]
m.setObjective(obj, gp.GRB.MAXIMIZE)

# Add constraints

m.addConstr(23 * x[2] + 15 * x[3] + 8 * x[5] >= 49)


productivity_rating_constraints = [
    (x[2], x[4], x[5], 91),
    (x[2], x[5], x[6], 91),
    (x[3], x[5], x[6], 91),
    (x[0], x[2], x[4], 91),
    (x[1], x[4], x[6], 91),
    (x[3], x[4], x[5], 91),
    (x[2], x[3], x[5], 91),
    (x[0], x[4], x[5], 91),
    (x[1], x[3], x[5], 91),
    (x[1], x[2], x[6], 91),
    (x[4], x[5], x[6], 91),
    (x[0], x[2], x[3], 91),
    (x[1], x[4], x[5], 91),
    (x[0], x[1], x[5], 91),
    (x[0], x[1], x[3], 91),
    (x[1], x[2], x[5], 91),
    (x[0], x[4], x[6], 91),
    (x[0], x[1], x[6], 91)
]

for i in range(len(productivity_rating_constraints)):
    vars = productivity_rating_constraints[i][:3]
    rhs = productivity_rating_constraints[i][3]
    coeffs = [10, 18, 6, 10, 6, 23, 1, 6, 23, 15, 10, 18, 11, 18, 23, 1, 18, 6, 10, 1, 6, 15, 18, 6, 11, 1, 6, 11, 10, 23, 18, 6, 23, 15, 10, 1, 11, 18, 6, 15, 11, 6, 15, 11, 1, 11, 10, 6, 15, 18, 23, 15, 11, 23]
    m.addConstr(
        coeffs[i*3] * vars[0] + coeffs[i*3+1] * vars[1] + coeffs[i*3+2] * vars[2] >= rhs
    )

# Add dollar cost constraints
dollar_cost_constraints = [
    (x[2], x[4], 455),
    (x[0], x[5], 364),
    (x[1], x[5], 244),
    (x[2], x[3], 112),
    (x[2], x[5], 482),
    (x[0], x[1], 414),
    (x[0], x[4], 513),
    (x[5], x[6], 245),
    (x[1], x[2], 496),
    (x[2], x[6], 429),
    (x[3], x[6], 86),
    (x[0], x[6], 176),
    (x[2], x[4], x[5], 478),
    (x[1], x[2], x[3], 197),
    (x[0], x[1], x[2], x[3], x[4], x[5], x[6], 197)
]
dollar_cost_coeffs = [3, 19, 23, 15, 20, 8, 1]

for i in range(len(dollar_cost_constraints)):
    constraint = dollar_cost_constraints[i]
    variables = constraint[:-1]
    rhs = constraint[-1]
    
    lhs = 0
    for j, var in enumerate(variables):
        if j < len(dollar_cost_coeffs):
            lhs += dollar_cost_coeffs[j] * var
        
    m.addConstr(lhs <= rhs)

# Add productivity rating constraints (similar structure as dollar cost constraints)
productivity_rating_constraints_2 = [
    (x[4], x[5], 977),
    (x[1], x[6], 478),
    (x[0], x[3], 186),
    (x[2], x[5], 733),
    (x[0], x[4], 394),
    (x[2], x[6], 835),
    (x[0], x[5], 983),
    (x[0], x[1], 787),
    (x[1], x[2], 640),
    (x[0], x[1], x[2], x[3], x[4], x[5], x[6], 640)
]
productivity_rating_coeffs = [15, 11, 10, 1, 18, 6, 23]

for i in range(len(productivity_rating_constraints_2)):
    constraint = productivity_rating_constraints_2[i]
    variables = constraint[:-1]
    rhs = constraint[-1]
    
    lhs = 0
    for j, var in enumerate(variables):
        if j < len(productivity_rating_coeffs):
            lhs += productivity_rating_coeffs[j] * var
        
    m.addConstr(lhs <= rhs)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
