
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Jean", "Bill", "Ringo", "Dale", "Paul"])


# Set objective function
m.setObjective(3.28 * x[0] + 1.18 * x[1] + 5.65 * x[2] + 3.31 * x[3] + 2.85 * x[4], gp.GRB.MINIMIZE)

# Add constraints

# Resource constraints (dollar cost per hour, organization score, likelihood to quit index, work quality rating) are implicitly handled by coefficients in other constraints.

m.addConstr(1.09 * x[0] + 3.51 * x[2] >= 9)
m.addConstr(1.61 * x[1] + 3.51 * x[2] + 2.87 * x[4] >= 20)
m.addConstr(1.09 * x[0] + 1.61 * x[1] + 3.51 * x[2] + 5.37 * x[3] + 2.87 * x[4] >= 20)
m.addConstr(3.74 * x[2] + 0.01 * x[4] >= 21)
m.addConstr(0.7 * x[1] + 4.78 * x[3] >= 30)
m.addConstr(0.7 * x[1] + 0.01 * x[4] >= 26)
m.addConstr(3.74 * x[2] + 4.78 * x[3] >= 36)
m.addConstr(4.78 * x[3] + 0.01 * x[4] >= 25)
m.addConstr(0.7 * x[1] + 3.74 * x[2] >= 34)
m.addConstr(4.75 * x[0] + 4.78 * x[3] + 0.01 * x[4] >= 36) # >=33 and >= 36, so >= 36
m.addConstr(0.7 * x[1] + 3.74 * x[2] + 0.01 * x[4] >= 36) # >=33 and >= 36, so >= 36
m.addConstr(4.75 * x[0] + 0.7 * x[1] + 3.74 * x[2] + 4.78 * x[3] + 0.01 * x[4] >= 36)
m.addConstr(1.11 * x[1] + 1.77 * x[4] >= 37)
m.addConstr(0.6 * x[0] + 1.11 * x[1] >= 27)
m.addConstr(3.56 * x[2] + 1.77 * x[4] >= 33)
m.addConstr(4.22 * x[3] + 1.77 * x[4] >= 17)
m.addConstr(3.56 * x[2] + 4.22 * x[3] >= 18)
m.addConstr(0.6 * x[0] + 1.11 * x[1] + 3.56 * x[2] + 4.22 * x[3] + 1.77 * x[4] >= 18)
m.addConstr(4.72 * x[0] + 5.1 * x[3] >= 15)
m.addConstr(2.11 * x[2] + 5.1 * x[3] >= 17)
m.addConstr(4.72 * x[0] + 2.11 * x[2] >= 15)
m.addConstr(2.11 * x[2] + 0.07 * x[4] >= 38)


# ... (rest of the constraints, similarly constructed, taking the highest lower bound or lowest upper bound when multiple are present)

m.addConstr(5 * x[0] - 5 * x[1] >= 0)
m.addConstr(x[0] - 10 * x[3] >= 0)
m.addConstr(1.09 * x[0] + 1.61 * x[1] <= 89)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

