
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(lb=0, name="x0")  # hours worked by Jean
x1 = m.addVar(lb=0, name="x1")  # hours worked by Bill
x2 = m.addVar(lb=0, name="x2")  # hours worked by Ringo
x3 = m.addVar(lb=0, name="x3")  # hours worked by Dale
x4 = m.addVar(lb=0, name="x4")  # hours worked by Paul

# Define the objective function
m.setObjective(3.28*x0 + 1.18*x1 + 5.65*x2 + 3.31*x3 + 2.85*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.09*x0 + 3.51*x2 >= 9)
m.addConstr(1.61*x1 + 3.51*x2 + 2.87*x4 >= 20)
m.addConstr(1.09*x0 + 1.61*x1 + 3.51*x2 + 5.37*x3 + 2.87*x4 >= 20)
m.addConstr(3.74*x2 + 0.01*x4 >= 21)
m.addConstr(0.7*x1 + 4.78*x3 >= 30)
m.addConstr(0.7*x1 + 0.01*x4 >= 26)
m.addConstr(3.74*x2 + 4.78*x3 >= 36)
m.addConstr(4.78*x3 + 0.01*x4 >= 25)
m.addConstr(0.7*x1 + 3.74*x2 >= 34)
m.addConstr(4.72*x0 + 4.78*x3 + 0.01*x4 >= 33)
m.addConstr(0.7*x1 + 3.74*x2 + 0.01*x4 >= 33)
m.addConstr(4.72*x0 + 4.78*x3 + 0.01*x4 >= 36)
m.addConstr(0.7*x1 + 3.74*x2 + 0.01*x4 >= 36)
m.addConstr(4.72*x0 + 0.7*x1 + 3.74*x2 + 4.78*x3 + 0.01*x4 >= 36)
m.addConstr(1.11*x1 + 1.77*x4 >= 37)
m.addConstr(0.6*x0 + 1.11*x1 >= 27)
m.addConstr(3.56*x2 + 1.77*x4 >= 33)
m.addConstr(4.22*x3 + 1.77*x4 >= 17)
m.addConstr(3.56*x2 + 4.22*x3 >= 18)
m.addConstr(0.6*x0 + 1.11*x1 + 3.56*x2 + 4.22*x3 + 1.77*x4 >= 18)
m.addConstr(4.72*x0 + 5.1*x3 >= 15)
m.addConstr(2.11*x2 + 5.1*x3 >= 17)
m.addConstr(4.72*x0 + 2.11*x2 >= 15)
m.addConstr(2.11*x2 + 0.07*x4 >= 38)
m.addConstr(4.72*x0 + 2.11*x2 + 5.1*x3 >= 39)
m.addConstr(4.72*x0 + 3.22*x1 + 5.1*x3 >= 39)
m.addConstr(2.11*x2 + 5.1*x3 + 0.07*x4 >= 39)
m.addConstr(3.22*x1 + 2.11*x2 + 5.1*x3 >= 39)
m.addConstr(3.22*x1 + 5.1*x3 + 0.07*x4 >= 39)
m.addConstr(4.72*x0 + 3.22*x1 + 0.07*x4 >= 39)
m.addConstr(4.72*x0 + 3.22*x1 + 2.11*x2 >= 39)
m.addConstr(3.22*x1 + 2.11*x2 + 0.07*x4 >= 39)
m.addConstr(4.72*x0 + 5.1*x3 + 0.07*x4 >= 39)
m.addConstr(4.72*x0 + 2.11*x2 + 0.07*x4 >= 39)
m.addConstr(4.72*x0 + 2.11*x2 + 5.1*x3 >= 41)
m.addConstr(4.72*x0 + 3.22*x1 + 5.1*x3 >= 41)
m.addConstr(2.11*x2 + 5.1*x3 + 0.07*x4 >= 41)
m.addConstr(3.22*x1 + 2.11*x2 + 5.1*x3 >= 41)
m.addConstr(3.22*x1 + 5.1*x3 + 0.07*x4 >= 41)
m.addConstr(5*x0 - 5*x1 >= 0)
m.addConstr(x0 - 10*x3 >= 0)
m.addConstr(1.09*x0 + 1.61*x1 <= 89)
m.addConstr(1.09*x0 + 1.61*x1 + 2.87*x4 <= 24)
m.addConstr(1.09*x0 + 1.61*x1 + 5.37*x3 <= 63)
m.addConstr(1.61*x1 + 5.37*x3 + 2.87*x4 <= 76)
m.addConstr(1.61*x1 + 3.51*x2 + 5.37*x3 <= 71)
m.addConstr(3.51*x2 + 5.37*x3 + 2.87*x4 <= 20)
m.addConstr(1.09*x0 + 5.37*x3 + 2.87*x4 <= 49)
m.addConstr(0.6*x0 + 3.56*x2 <= 154)
m.addConstr(3.56*x2 + 4.22*x3 <= 112)
m.addConstr(3.56*x2 + 1.77*x4 <= 55)
m.addConstr(1.11*x1 + 4.22*x3 <= 187)
m.addConstr(1.11*x1 + 1.77*x4 <= 101)
m.addConstr(0.6*x0 + 1.11*x1 <= 112)
m.addConstr(0.6*x0 + 4.22*x3 <= 148)
m.addConstr(0.6*x0 + 3.56*x2 + 1.77*x4 <= 164)
m.addConstr(0.6*x0 + 1.11*x1 + 4.22*x3 <= 52)

# Solve the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("x0: ", x0.varValue)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
print("x3: ", x3.varValue)
print("x4: ", x4.varValue)
