
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bobby_hours = model.addVar(lb=0, name="bobby_hours")  # Continuous
    bill_hours = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bill_hours") # Integer

    # Set objective function
    model.setObjective(8 * bobby_hours + 5 * bill_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * bobby_hours + 27 * bill_hours >= 49, "work_quality_min")
    model.addConstr(21 * bobby_hours + 26 * bill_hours >= 50, "organization_score_min")
    model.addConstr(-4 * bobby_hours + 3 * bill_hours >= 0, "hours_relation")
    model.addConstr(7 * bobby_hours + 27 * bill_hours <= 93, "work_quality_max")
    model.addConstr(21 * bobby_hours + 26 * bill_hours <= 115, "organization_score_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Bobby: {bobby_hours.x}")
        print(f"Hours worked by Bill: {bill_hours.x}")
        print(f"Optimal Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
