
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Bill")

# Define the objective function
m.setObjective(8*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 27*x2 >= 49, "work_quality_rating")
m.addConstr(21*x1 + 26*x2 >= 50, "organization_score_min")
m.addConstr(-4*x1 + 3*x2 >= 0, "hours_worked_constraint")
m.addConstr(7*x1 + 27*x2 <= 93, "work_quality_rating_max")
m.addConstr(21*x1 + 26*x2 <= 115, "organization_score_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
