
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative
x2 = m.addVar(name="hours_worked_by_Bill", lb=0, integrality=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(8 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * x1 + 27 * x2 >= 49)
m.addConstr(21 * x1 + 26 * x2 >= 50)
m.addConstr(-4 * x1 + 3 * x2 >= 0)
m.addConstr(7 * x1 + 27 * x2 <= 93)
m.addConstr(21 * x1 + 26 * x2 <= 115)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x1.varValue)
    print("Hours worked by Bill: ", x2.varValue)
else:
    print("The model is infeasible")
