
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
sashimi = m.addVar(vtype=gp.GRB.INTEGER, name="sashimi")
ham_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="ham_sandwiches")
milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")
potatoes = m.addVar(vtype=gp.GRB.INTEGER, name="potatoes")
kale_salads = m.addVar(vtype=gp.GRB.INTEGER, name="kale_salads")

# Set objective function
m.setObjective(9*sashimi + 9*ham_sandwiches + 5*milkshakes + 9*potatoes + 8*kale_salads, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(11*ham_sandwiches + 9*potatoes >= 66)
m.addConstr(8*sashimi + 9*potatoes >= 40)
m.addConstr(17*milkshakes + 9*potatoes >= 33)
m.addConstr(11*ham_sandwiches + 17*milkshakes + 9*potatoes >= 57)
m.addConstr(8*sashimi + 11*ham_sandwiches + 18*kale_salads >= 57)
m.addConstr(8*sashimi + 17*milkshakes + 9*potatoes >= 57)
m.addConstr(11*ham_sandwiches + 17*milkshakes + 18*kale_salads >= 57)
m.addConstr(17*milkshakes + 9*potatoes + 18*kale_salads >= 57)
m.addConstr(11*ham_sandwiches + 17*milkshakes + 9*potatoes >= 63)
m.addConstr(8*sashimi + 11*ham_sandwiches + 18*kale_salads >= 63)
m.addConstr(8*sashimi + 17*milkshakes + 9*potatoes >= 63)
m.addConstr(11*ham_sandwiches + 17*milkshakes + 18*kale_salads >= 63)
m.addConstr(17*milkshakes + 9*potatoes + 18*kale_salads >= 63)
m.addConstr(11*ham_sandwiches + 17*milkshakes + 9*potatoes >= 64)
m.addConstr(8*sashimi + 11*ham_sandwiches + 18*kale_salads >= 64)
m.addConstr(8*sashimi + 17*milkshakes + 9*potatoes >= 64)
m.addConstr(11*ham_sandwiches + 17*milkshakes + 18*kale_salads >= 64)
m.addConstr(17*milkshakes + 9*potatoes + 18*kale_salads >= 64)
m.addConstr(8*sashimi + 11*ham_sandwiches + 17*milkshakes + 9*potatoes + 18*kale_salads >= 64)
m.addConstr(-10*sashimi + ham_sandwiches >= 0)
m.addConstr(8*ham_sandwiches - 7*kale_salads >= 0)
m.addConstr(8*sashimi + 11*ham_sandwiches + 18*kale_salads <= 150)
m.addConstr(11*ham_sandwiches + 9*potatoes + 18*kale_salads <= 194)
m.addConstr(8*sashimi + 9*potatoes + 18*kale_salads <= 217)
m.addConstr(17*milkshakes + 9*potatoes + 18*kale_salads <= 282)
m.addConstr(8*sashimi + 11*ham_sandwiches + 17*milkshakes + 9*potatoes + 18*kale_salads <= 367)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

