
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin K
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of zinc
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of potassium


    # Set objective function
    m.setObjective(3*x0 + 2*x1 + 8*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2.2*x0 + 0.26*x1 >= 22)
    m.addConstr(0.26*x1 + 2.58*x2 >= 13)
    m.addConstr(2.2*x0 + 0.26*x1 + 2.58*x2 >= 13)
    m.addConstr(3.99*x0 + 2.9*x1 >= 13)
    m.addConstr(3.99*x0 + 2.61*x2 >= 12)
    m.addConstr(3.99*x0 + 2.9*x1 + 2.61*x2 >= 11)
    m.addConstr(0.79*x1 + 4.67*x2 >= 8)
    m.addConstr(0.26*x0 + 0.79*x1 >= 14)
    m.addConstr(0.26*x0 + 0.79*x1 + 4.67*x2 >= 14)
    m.addConstr(3*x1 - 7*x2 >= 0)
    m.addConstr(2.9*x1 + 2.61*x2 <= 38)
    m.addConstr(3.99*x0 + 2.9*x1 <= 22)

    # Resource Constraints
    m.addConstr(2.2*x0 <= 71)
    m.addConstr(3.99*x0 <= 61)
    m.addConstr(0.26*x0 <= 64)
    m.addConstr(0.26*x1 <= 71)
    m.addConstr(2.9*x1 <= 61)
    m.addConstr(0.79*x1 <= 64)
    m.addConstr(2.58*x2 <= 71)
    m.addConstr(2.61*x2 <= 61)
    m.addConstr(4.67*x2 <= 64)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
