
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # milligrams of vitamin K
x2 = m.addVar(name="x2")  # milligrams of zinc
x3 = m.addVar(name="x3")  # milligrams of potassium

# Define the objective function
m.setObjective(3*x1 + 2*x2 + 8*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.2*x1 <= 71)
m.addConstr(3.99*x1 <= 61)
m.addConstr(0.26*x1 <= 64)
m.addConstr(0.26*x2 <= 71)
m.addConstr(2.9*x2 <= 61)
m.addConstr(0.79*x2 <= 64)
m.addConstr(2.58*x3 <= 71)
m.addConstr(2.61*x3 <= 61)
m.addConstr(4.67*x3 <= 64)
m.addConstr(2.2*x1 + 0.26*x2 >= 22)
m.addConstr(0.26*x2 + 2.58*x3 >= 13)
m.addConstr(2.2*x1 + 0.26*x2 + 2.58*x3 >= 13)
m.addConstr(3.99*x1 + 2.9*x2 >= 13)
m.addConstr(3.99*x1 + 2.61*x3 >= 12)
m.addConstr(3.99*x1 + 2.9*x2 + 2.61*x3 >= 11)
m.addConstr(0.79*x2 + 4.67*x3 >= 8)
m.addConstr(0.26*x1 + 0.79*x2 >= 14)
m.addConstr(0.26*x1 + 0.79*x2 + 4.67*x3 >= 14)
m.addConstr(3*x2 - 7*x3 >= 0)
m.addConstr(2.9*x2 + 2.61*x3 <= 38)
m.addConstr(3.99*x1 + 2.9*x2 <= 22)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin K: {x1.varValue}")
    print(f"Milligrams of zinc: {x2.varValue}")
    print(f"Milligrams of potassium: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
