
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="x0")  # hours worked by Mary
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1") # hours worked by Hank
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # hours worked by Jean
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="x3") # hours worked by Ringo
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="x4") # hours worked by Laura
x5 = m.addVar(vtype=GRB.CONTINUOUS, name="x5") # hours worked by George
x6 = m.addVar(vtype=GRB.INTEGER, name="x6") # hours worked by Bill


# Set objective
obj = 8*x0**2 + 3*x0*x1 + 9*x0*x2 + 2*x0*x3 + 5*x0*x4 + 2*x0*x5 + 6*x0*x6 + 3*x1*x2 + 4*x1*x3 + 8*x1*x4 + 9*x1*x5 + 4*x1*x6 + 6*x2**2 + 5*x2*x3 + 3*x2*x4 + 2*x2*x5 + 9*x2*x6 + 4*x3**2 + 5*x3*x5 + 4*x3*x6 + 2*x4**2 + 8*x5**2 + 1*x5*x6 + 1*x6**2 + 3*x0 + 1*x1 + 7*x2 + 5*x3 + 1*x4 + 3*x5 + 7*x6
m.setObjective(obj, GRB.MAXIMIZE)


# Add constraints

# Resource constraints
r0 = 9*x0 + 9*x1 + 4*x2 + 8*x3 + 6*x4 + 6*x5 + x6
r1 = x0 + 2*x1 + 8*x2 + 11*x3 + 10*x4 + 4*x5 + 11*x6

m.addConstr(r0 <= 229, "r0_ub")
m.addConstr(r1 <= 241, "r1_ub")


constraints_work_quality = [
    (9*x1 + 4*x2 >= 24),
    (6*x4 + 1*x6 >= 30),
    (9*x1 + 6*x5 >= 30),
    (9*x1 + 1*x6 >= 23),
    (9*x0 + 8*x3 >= 26),
    (9*x1 + 6*x4 >= 11),
    (8*x3 + 6*x4 + 1*x6 >= 23),
    (9*x0**2 + 6*x4**2 + 1*x6**2 >= 23),
    (9*x0 + 4*x2 + 6*x4 >= 23),
    (9*x0 + 9*x1 + 1*x6 >= 23),
    (9*x1 + 6*x5 + 1*x6 >= 23),
    (9*x0 + 4*x2 + 1*x6 >= 23),
    (9*x0 + 6*x5 + 1*x6 >= 23),
    (9*x1 + 6*x4 + 1*x6 >= 23),
    (9*x1 + 4*x2 + 6*x5 >= 23),
    (8*x3 + 6*x4 + 1*x6 >= 25),
    (9*x0 + 6*x4 + 1*x6 >= 25),
    (9*x0**2 + 4*x2**2 + 6*x4**2 >= 25),
    (9*x0 + 9*x1 + 1*x6 >= 25),
    (9*x1 + 6*x5 + 1*x6 >= 25),
    (9*x0 + 4*x2 + 1*x6 >= 25),
    (9*x0**2 + 6*x5**2 + 1*x6**2 >= 25),
    (9*x1**2 + 6*x4**2 + 1*x6**2 >= 25),
    (9*x1**2 + 4*x2**2 + 6*x5**2 >= 25),
    (8*x3 + 6*x4 + 1*x6 >= 27),
    (9*x0 + 6*x4 + 1*x6 >= 27),
    (9*x0 + 4*x2 + 6*x4 >= 27),
    (9*x0 + 9*x1 + 1*x6 >= 27),
    (9*x1 + 6*x5 + 1*x6 >= 27),
    (9*x0**2 + 4*x2**2 + 1*x6**2 >= 27),
    (9*x0 + 6*x5 + 1*x6 >= 27),
    (9*x1 + 6*x4 + 1*x6 >= 27),
    (9*x1 + 4*x2 + 6*x5 >= 27),
    (8*x3 + 6*x4 + 1*x6 >= 22),
    (9*x0 + 6*x4 + 1*x6 >= 22),
    (9*x0 + 4*x2 + 6*x4 >= 22),
    (9*x0 + 9*x1 + 1*x6 >= 22),
    (9*x1 + 6*x5 + 1*x6 >= 22),
    (9*x0 + 4*x2 + 1*x6 >= 22),
    (9*x0 + 6*x5 + 1*x6 >= 22),
    (9*x1 + 6*x4 + 1*x6 >= 22),
    (9*x1 + 4*x2 + 6*x5 >= 22),
    (8*x3**2 + 6*x4**2 + 1*x6**2 >= 29),
    (9*x0**2 + 6*x4**2 + 1*x6**2 >= 29),
    (9*x0**2 + 4*x2**2 + 6*x4**2 >= 29),
    (9*x0 + 9*x1 + 1*x6 >= 29),
    (9*x1**2 + 6*x5**2 + 1*x6**2 >= 29),
    (9*x0**2 + 4*x2**2 + 1*x6**2 >= 29),
    (9*x0 + 6*x5 + 1*x6 >= 29),
    (9*x1**2 + 6*x4**2 + 1*x6**2 >= 29),
    (9*x1 + 4*x2 + 6*x5 >= 29),
    (8*x3 + 6*x4 + 1*x6 >= 23),
    (9*x0 + 6*x4 + 1*x6 >= 23),
    (9*x0**2 + 4*x2**2 + 6*x4**2 >= 23),
    (9*x0 + 9*x1 + 1*x6 >= 23),
    (9*x1 + 6*x5 + 1*x6 >= 23),
    (9*x0 + 4*x2 + 1*x6 >= 23),
    (9*x0 + 6*x5 + 1*x6 >= 23),
    (9*x1**2 + 6*x4**2 + 1*x6**2 >= 23),
    (9*x1 + 4*x2 + 6*x5 >= 23),
    (8*x3 + 6*x4 + 1*x6 >= 18),
    (9*x0 + 6*x4 + 1*x6 >= 18),
    (9*x0 + 4*x2 + 6*x4 >= 18),
    (9*x0 + 9*x1 + 1*x6 >= 18),
    (9*x1 + 6*x5 + 1*x6 >= 18),
    (9*x0**2 + 4*x2**2 + 1*x6**2 >= 18),
    (9*x0 + 6*x5 + 1*x6 >= 18),
    (9*x1 + 6*x4 + 1*x6 >= 18),
    (9*x1 + 4*x2 + 6*x5 >= 18),
    (8*x3**2 + 6*x4**2 + 1*x6**2 >= 28),
    (9*x0 + 6*x4 + 1*x6 >= 28),
    (9*x0 + 4*x2 + 6*x4 >= 28),
    (9*x0 + 9*x1 + 1*x6 >= 28),
    (9*x1 + 6*x5 + 1*x6 >= 28),
    (9*x0**2 + 4*x2**2 + 1*x6**2 >= 28),
    (9*x0 + 6*x5 + 1*x6 >= 28),
    (9*x1 + 6