
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
x1 = m.addVar(name="x1", lb=0)  # hours worked by Mary
x2 = m.addVar(name="x2", lb=0)  # hours worked by Hank
x3 = m.addVar(name="x3", lb=0)  # hours worked by Jean
x4 = m.addVar(name="x4", lb=0)  # hours worked by Ringo
x5 = m.addVar(name="x5", lb=0)  # hours worked by Laura
x6 = m.addVar(name="x6", lb=0)  # hours worked by George
x7 = m.addVar(name="x7", lb=0, integrality=1)  # hours worked by Bill, integer

# Objective function
m.setObjective(8*x1**2 + 3*x1*x2 + 9*x1*x3 + 2*x1*x4 + 5*x1*x5 + 2*x1*x6 + 6*x1*x7 + 
               3*x2*x3 + 4*x2*x4 + 8*x2*x5 + 9*x2*x6 + 4*x2*x7 + 6*x3**2 + 5*x3*x4 + 
               3*x3*x5 + 2*x3*x6 + 9*x3*x7 + 4*x4**2 + 5*x4*x6 + 4*x4*x7 + 2*x5**2 + 
               8*x6**2 + x6*x7 + x7**2 + 3*x1 + x2 + 7*x3 + 5*x4 + x5 + 3*x6 + 7*x7, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(9*x1 == 9)
m.addConstr(x1 == 1)
m.addConstr(9*x2 == 9)
m.addConstr(2*x2 == 2)
m.addConstr(4*x3 == 4)
m.addConstr(8*x3 == 8)
m.addConstr(8*x4 == 8)
m.addConstr(11*x4 == 11)
m.addConstr(6*x5 == 6)
m.addConstr(10*x5 == 10)
m.addConstr(6*x6 == 6)
m.addConstr(4*x6 == 4)
m.addConstr(x7 == 1)
m.addConstr(11*x7 == 11)

# Add remaining constraints...

# Optimize the model
m.optimize()

# Print the objective value
print("Objective: ", m.objVal)

# Print the solution
for v in m.getVars():
    print(v.varName, ":", v.x)
