
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b4")
iron = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")
magnesium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="magnesium")
fiber = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="fiber")
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b1")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b2")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b7")


# Set objective function
m.setObjective(2.91 * vitamin_b4 + 8.45 * iron + 1.9 * magnesium + 1.08 * fiber + 6.88 * vitamin_b1 + 3.4 * vitamin_b2 + 3.55 * vitamin_e + 8.47 * vitamin_b7, gp.GRB.MINIMIZE)

# Add resource constraints
resources = {
    'r0': {'upper_bound': 300, 'coeffs': [8, 7, 20, 4, 20, 20, 16, 18]},
    'r1': {'upper_bound': 376, 'coeffs': [4, 4, 5, 13, 18, 7, 5, 17]},
    'r2': {'upper_bound': 782, 'coeffs': [14, 15, 16, 5, 7, 13, 12, 16]},
    'r3': {'upper_bound': 796, 'coeffs': [12, 18, 6, 14, 6, 5, 3, 6]},
    'r4': {'upper_bound': 663, 'coeffs': [20, 6, 18, 20, 11, 18, 4, 20]}
}

variables = [vitamin_b4, iron, magnesium, fiber, vitamin_b1, vitamin_b2, vitamin_e, vitamin_b7]

for r, data in resources.items():
    m.addConstr(gp.quicksum(data['coeffs'][i] * variables[i] for i in range(len(variables))) <= data['upper_bound'], name=r)


# Add  constraints from the prompt. Due to the large number of similar constraints,
# they are programmatically generated.

# Muscle Growth Index Constraints
muscle_growth_constraints = [
    ([0, 5], 29), ([0, 3], 28), ([4, 5], 12), ([1, 6], 33), ([0, 7], 27), ([0, 6], 37),
    ([2, 3, 5], 34), ([1, 3, 6], 34), ([1, 2, 7], 34), ([0, 2, 4], 34), ([0, 6, 7], 34),
    ([2, 5, 7], 34), ([1, 4, 5], 34), ([1, 2, 4], 34), ([0, 4, 6], 34), ([0, 1, 2], 34),
    ([4, 5, 7], 34), ([0, 3, 6], 34), ([0, 1, 3], 34), ([2, 5, 6], 34), ([2, 4, 6], 34),
    ([0, 3, 7], 34), ([2, 3, 6], 34),
    ([2, 3, 5], 36), ([1, 3, 6], 36), ([1, 2, 7], 36), ([0, 2, 4], 36), ([0, 6, 7], 36),
    ([2, 5, 7], 36), ([1, 4, 5], 36), ([1, 2, 4], 36), ([0, 4, 6], 36), ([0, 1, 2], 36),
    ([4, 5, 7], 36), ([0, 3, 6], 36), ([0, 1, 3], 36), ([2, 5, 6], 36), ([2, 4, 6], 36),
    ([0, 3, 7], 36), ([2, 3, 6], 36),
    ([2, 3, 5], 19), ([1, 3, 6], 19), ([1, 2, 7], 19), ([0, 2, 4], 19), ([0, 6, 7], 19),
    ([2, 5, 7], 19), ([1, 4, 5], 19), ([1, 2, 4], 19), ([0, 4, 6], 19), ([0, 1, 2], 19),
    ([4, 5, 7], 19), ([0, 3, 6], 19), ([0, 1, 3], 19), ([2, 5, 6], 19), ([2, 4, 6], 19),
    ([0, 3, 7], 19), ([2, 3, 6], 19),
    ([2, 3, 5], 25), ([1, 3, 6], 25), ([1, 2, 7], 25), ([0, 2, 4], 25), ([0, 6, 7], 25),
    ([2, 5, 7], 25), ([1, 4, 5], 25), ([1, 2, 4], 25), ([0, 4, 6], 25), ([0, 1, 2], 25),
    ([4, 5, 7], 25), ([0, 3, 6], 25), ([0, 1, 3], 25), ([2, 5, 6], 25), ([2, 4, 6], 25),
    ([0, 3, 7], 25), ([2, 3, 6], 25),
    ([2, 3, 5], 32), ([1, 3, 6], 32), ([1, 2, 7], 32), ([0, 2, 4], 32), ([0, 6, 7], 32),
    ([2, 5, 7], 32), ([1, 4, 5], 32), ([1, 2, 4], 32), ([0, 4, 6], 32), ([0, 1, 2], 32),
    ([4, 5, 7], 32), ([0, 3, 6], 32), ([0, 1, 3], 32), ([2, 5, 6], 32), ([2, 4, 6], 32),
    ([0, 3, 7], 32), ([2, 3, 6], 32),
    ([2, 3, 5], 36), ([1, 3, 6], 36), ([1, 2, 7], 36), ([0, 2, 4], 36), ([0, 6, 7], 36),
    ([2, 5, 7], 36), ([1, 4, 5], 36), ([1, 2, 4], 36), ([0, 4, 6], 36), ([0, 1, 2], 36),
    ([4, 5, 7], 36), ([0, 3, 6], 36), ([0, 1, 3], 36), ([2, 5, 6], 36), ([2, 4, 6], 36),
    ([0, 3, 7], 36), ([2, 3, 6], 36),
    ([2, 3, 5], 35), ([1, 3, 6], 35), ([1, 2, 7], 35), ([0, 2, 4], 35), ([0, 6, 7], 35),
    ([2, 5, 7], 35), ([1, 4, 5], 35), ([1, 2, 4], 35), ([0, 4, 6], 35), ([0, 1, 2], 35),
    ([4, 5, 7], 35), ([0, 3, 6], 35), ([0, 1, 3], 35), ([2, 5, 6], 35), ([2, 4, 6], 35),
    ([0, 3, 7], 35), ([2, 3, 6], 35),
    ([2, 3, 5], 33), ([1, 3, 6], 33), ([1, 2, 7], 33), ([0, 2, 4], 33), ([0, 6, 7], 33),
    ([2, 5, 7], 33), ([1, 4, 5], 33), ([1, 2, 4], 33), ([0, 4, 6], 33), ([0, 1, 2], 33),
    ([4, 5, 7], 33), ([0, 3, 6], 33), ([0, 1, 3], 33), ([2, 5, 6], 33), ([2, 4, 6], 33),
    ([0, 3, 7], 33), ([2, 3, 6], 33),
    ([2, 3, 5], 28), ([1, 3, 6], 28), ([1, 2, 7], 28), ([0, 2, 4], 28), ([0, 6, 7], 28),
    ([2, 5, 7], 28), ([1, 4, 5], 28), ([1, 2, 4], 28), ([0, 4, 6], 28), ([0, 1, 2], 28),
    ([4, 5, 7], 28), ([0, 3, 6], 28), ([0, 1, 3], 28), ([2, 5, 6], 28), ([2, 4, 6], 28),
    ([0, 3, 7], 28), ([2, 3, 6], 28),
    ([2, 3, 5], 21), ([1, 3, 6], 21), ([1, 2, 7], 21), ([0, 2, 4], 21), ([0, 6, 7], 21),
    ([2, 5, 7], 21), ([1, 4, 5], 21), ([1, 2, 4], 21), ([0, 4, 6], 21), ([0, 1, 2], 21),
    ([4, 5, 7], 21), ([0, 3, 6], 21), ([0, 1, 3], 21), ([2, 5, 6], 21), ([2, 4, 6], 21),
    ([0, 3, 7], 21), ([2, 3, 6], 21),
    ([2, 3, 5], 29), ([1, 3, 6], 29), ([1, 2, 7], 29), ([0, 2, 4], 29), ([0, 6, 7], 29),
    ([2, 5, 7], 29), ([1, 4, 5], 29), ([1, 2, 4], 29), ([0, 4, 6], 29), ([0, 1, 2], 29),
    ([4, 5, 7], 29), ([0, 3, 6], 29), ([0, 1, 3], 29), ([2, 5, 6], 29), ([2, 4, 6], 29),
    ([0, 3, 7], 29), ([2, 3, 6], 29),
    ([2, 3, 5], 32), ([1, 3, 6], 32), ([1, 2, 7], 32), ([0, 2, 4], 32), ([0, 6, 7], 32),
    ([2, 5, 7], 32), ([1, 4, 5], 32), ([1, 2, 4], 32), ([0, 4, 6], 32), ([0, 1, 2], 32),
    ([4, 5, 7], 32), ([0, 3, 6], 32), ([0, 1, 3], 32), ([2, 5, 6], 32), ([2, 4, 6], 32),
    ([0, 3, 7], 32), ([2, 3, 6], 32),
    ([2, 3, 5], 25), ([1, 3, 6], 25), ([1, 2, 7], 25), ([0, 2, 4], 25), ([0, 6, 7], 25),
    ([2, 5, 7], 25), ([1, 4, 5], 25), ([1, 2, 4], 25), ([0, 4, 6], 25), ([0, 1, 2], 25),
    ([4, 5, 7], 25), ([0, 3, 6], 25), ([0, 1, 3], 25), ([2, 5, 6], 25), ([2, 4, 6], 25),
    ([0, 3, 7], 25), ([2, 3, 6], 25),
    ([2, 3, 5], 24), ([1, 3, 6], 24), ([1, 2, 7], 24), ([0, 2, 4], 24), ([0, 6, 7], 24),
    ([2, 5, 7], 24), ([1, 4, 5], 24), ([1, 2, 4], 24), ([0, 4, 6], 24), ([0, 1, 2], 24),
    ([4, 5, 7], 24), ([0, 3, 6], 24), ([0, 1, 3], 24), ([2, 5, 6], 24), ([2, 4, 6], 24),
    ([0, 3, 7], 24), ([2, 3, 6], 24),
    ([2, 3, 5], 28), ([1, 3, 6], 28), ([1, 2, 7], 28), ([0, 2, 4], 28), ([0, 6, 7], 28),
    ([2, 5, 7], 28), ([1, 4, 5], 28), ([1, 2, 4], 28), ([0, 4, 6], 28), ([0, 1, 2], 28),
    ([4, 5, 7], 28), ([0, 3, 6], 28), ([0, 1, 3], 28), ([2, 5, 6], 28), ([2, 4, 6], 28),
    ([0, 3, 7], 28), ([2, 3, 6], 28),
    ([2, 3, 5], 34), ([1, 3, 6], 34), ([1, 2, 7], 34), ([0, 2, 4], 34), ([0, 6, 7], 34),
    ([2, 5, 7], 34), ([1, 4, 5], 34), ([1, 2, 4], 34), ([0, 4, 6], 34), ([0, 1, 2], 34),
    ([4, 5, 7], 34), ([0, 3, 6], 34), ([0, 1, 3], 34), ([2, 5, 6], 34), ([2, 4, 6], 34),
    ([0, 3, 7], 34), ([2, 3, 6], 34),
    ([2, 3, 5], 18), ([1, 3, 6], 18), ([1, 2, 7], 18), ([0, 2, 4], 18), ([0, 6, 7], 18),
    ([2, 5, 7], 18), ([1, 4, 5], 18), ([1, 2, 4], 18), ([0, 4, 6], 18), ([0, 1, 2], 18),
    ([4, 5, 7], 18), ([0, 3, 6], 18), ([0, 1, 3], 18), ([2, 5, 6], 18), ([2, 4, 6], 18),
    ([0, 3, 7], 18), ([2, 3, 6], 18),
    ([0, 1, 2, 3, 4, 5, 6, 7], 18)
]


for indices, bound in muscle_growth_constraints:
    coeffs = [resources['r0']['coeffs'][i] if i in indices else 0 for i in range(len(variables))]
    m.addConstr(gp.quicksum(coeffs[i] * variables[i] for i in range(len(variables))) >= bound)


# Kidney Support Index Constraints - generated programmatically as above
kidney_support_constraints = [
([0,6], 25), ([5,6], 41), ([4,7], 32), ([2,5], 18), ([4,6], 26), ([0,2], 28), ([2,7], 20), ([3,6,7], 27), ([2,5,7], 27), ([0,3,7], 27), ([1,4,5], 27), ([2,3,5], 27), ([0,4,6], 27), ([0,1,7], 27), ([0,2,3], 27), ([1,5,6], 27), ([1,2,6], 27), ([2,3,4], 27), ([1,6,7], 27), ([2,6,7], 27), ([1,3,7], 27), ([0,1,5], 27), ([3,4,6], 27), ([0,2,6], 27), ([0,1,2], 27), ([0,4,7], 27), ([1,3,5], 27), ([0,6,7], 27), ([4,5,7], 27), ([1,2,3], 27), ([4,6,7], 27), ([1,3,4], 27), ([1,2,4], 27), ([3,4,5], 27), ([2,4,7], 27), ([0,1,3], 27),
([3,6,7], 32), ([2,5,7], 32), ([0,3,7], 32), ([1,4,5], 32), ([2,3,5], 32), ([0,4,6], 32), ([0,1,7], 32), ([0,2,3], 32), ([1,5,6], 32), ([1,2,6], 32), ([2,3,4], 32), ([1,6,7], 32), ([2,6,7], 32), ([1,3,7], 32), ([0,1,5], 32), ([3,4,6], 32), ([0,2,6], 32), ([0,1,2], 32), ([0,4,7], 32), ([1,3,5], 32), ([0,6,7], 32), ([4,5,7], 32), ([1,2,3], 32), ([4,6,7], 32), ([1,3,4], 32), ([1,2,4], 32), ([3,4,5], 32), ([2,4,7], 32), ([0,1,3], 32),
([3,6,7], 44), ([2,5,7], 44), ([0,3,7], 44), ([1,4,5], 44), ([2,3,5], 44), ([0,4,6], 44), ([0,1,7], 44), ([0,2,3], 44), ([1,5,6], 44), ([1,2,6], 44), ([2,3,4], 44), ([1,6,7], 44), ([2,6,7], 44), ([1,3,7], 44), ([0,1,5], 44), ([3,4,6], 44), ([0,2,6], 44), ([0,1,2], 44), ([0,4,7], 44), ([1,3,5], 44), ([0,6,7], 44), ([4,5,7], 44), ([1,2,3], 44), ([4,6,7], 44), ([1,3,4], 44), ([1,2,4], 44), ([3,4,5], 44), ([2,4,7], 44), ([0,1,3], 44),
([3,6,7], 43), ([2,5,7], 43), ([0,3,7], 43), ([1,4,5], 43), ([2,3,5], 43), ([0,4,6], 43), ([0,1,7], 43), ([0,2,3], 43), ([1,5,6], 43), ([1,2,6], 43), ([2,3,4], 43), ([1,6,7], 43), ([2,6,7], 43), ([1,3,7], 43), ([0,1,5], 43), ([3,4,6], 43), ([0,2,6], 43), ([0,1,2], 43), ([0,4,7], 43), ([1,3,5], 43), ([0,6,7], 43), ([4,5,7], 43), ([1,2,3], 43), ([4,6,7], 43), ([1,3,4], 43), ([1,2,4], 43), ([3,4,5], 43), ([2,4,7], 43), ([0,1,3], 43),

([3,6,7], 24), ([2,5,7], 24), ([0,3,7], 24), ([1,4,5], 24), ([2,3,5], 24), ([0,4,6], 24), ([0,1,7], 24), ([0,2,3], 24), ([1,5,6], 24), ([1,2,6], 24), ([2,3,4], 24), ([1,6,7], 24), ([2,6,7], 24), ([1,3,7], 24), ([0,1,5], 24), ([3,4,6], 24), ([0,2,6], 24), ([0,1,2], 24), ([0,4,7], 24), ([1,3,5], 24), ([0,6,7], 24), ([4,5,7], 24), ([1,2,3], 24), ([4,6,7], 24), ([1,3,4], 24), ([1,2,4], 24), ([3,4,5], 24), ([2,4,7], 24), ([0,1,3], 24),
([3,6,7], 47), ([2,5,7], 47), ([0,3,7], 47), ([1,4,5], 47), ([2,3,5], 47), ([0,4,6], 47), ([0,1,7], 47), ([0,2,3], 47), ([1,5,6], 47), ([1,2,6], 47), ([2,3,4], 47), ([1,6,7], 47), ([2,6,7], 47), ([1,3,7], 47), ([0,1,5], 47), ([3,4,6], 47), ([0,2,6], 47), ([0,1,2], 47), ([0,4,7], 47), ([1,3,5], 47), ([0,6,7], 47), ([4,5,7], 47), ([1,2,3], 47), ([4,6,7], 47), ([1,3,4], 47), ([1,2,4], 47), ([3,4,5], 47), ([2,4,7], 47), ([0,1,3], 47),
([3,6