
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="apples")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")

# Define the objective function
m.setObjective(9.29*x1**2 + 3.05*x1*x2 + 9.45*x2*x3 + 7.93*x1 + 6.27*x2 + 8.08*x3, GRB.MAXIMIZE)

# Define the constraints
m.addConstr(0.43*x2 + 2.94*x3 >= 31, name="fiber_from_eggs_and_ramen")
m.addConstr((2.67*x1)**2 + (2.94*x3)**2 >= 16, name="fiber_from_apples_and_ramen_squared")
m.addConstr((0.43*x2)**2 + (2.94*x3)**2 <= 97, name="fiber_from_eggs_and_ramen_squared")
m.addConstr(2.67*x1 + 0.43*x2 <= 90, name="fiber_from_apples_and_eggs")
m.addConstr(2.67*x1 + 0.43*x2 + 2.94*x3 <= 90, name="fiber_from_all")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective value: {m.objVal}")
