
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by George
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by John
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # hours worked by Jean
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # hours worked by Bobby


    # Set objective function
    model.setObjective(3*x0 + 6*x1 + 5*x2 + x3, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 6*x2 + 9*x3 >= 45, "c1")
    model.addConstr(10*x0 + 4*x1 + 6*x2 >= 45, "c2")
    model.addConstr(4*x1 + 6*x2 + 9*x3 >= 50, "c3")
    model.addConstr(10*x0 + 4*x1 + 6*x2 >= 50, "c4")
    model.addConstr(10*x0 + 4*x1 <= 240, "c5")
    model.addConstr(6*x2 + 9*x3 <= 265, "c6")
    model.addConstr(10*x0 + 4*x1 + 9*x3 <= 175, "c7")
    model.addConstr(10*x0 + 4*x1 + 6*x2 + 9*x3 <= 175, "c8")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
