
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='hours_worked_by_George', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_John')
    x3 = model.addVar(name='hours_worked_by_Jean', vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name='hours_worked_by_Bobby')

    # Objective function
    model.setObjective(3*x1 + 6*x2 + 5*x3 + x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x1 <= 273)
    model.addConstr(4*x2 <= 273)
    model.addConstr(6*x3 <= 273)
    model.addConstr(9*x4 <= 273)
    model.addConstr(4*x2 + 6*x3 + 9*x4 >= 45)
    model.addConstr(10*x1 + 4*x2 + 6*x3 >= 45)
    model.addConstr(4*x2 + 6*x3 + 9*x4 >= 50)
    model.addConstr(10*x1 + 4*x2 + 6*x3 >= 50)
    model.addConstr(10*x1 + 4*x2 <= 240)
    model.addConstr(6*x3 + 9*x4 <= 265)
    model.addConstr(10*x1 + 4*x2 + 9*x4 <= 175)
    model.addConstr(10*x1 + 4*x2 + 6*x3 + 9*x4 <= 175)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('Hours worked by George: ', x1.varValue)
        print('Hours worked by John: ', x2.varValue)
        print('Hours worked by Jean: ', x3.varValue)
        print('Hours worked by Bobby: ', x4.varValue)
    else:
        print('No solution found')

solve_optimization_problem()
