
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(vtype=gp.GRB.INTEGER, name="hot_dogs")
strawberries = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")
apple_pies = m.addVar(vtype=gp.GRB.INTEGER, name="apple_pies")
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
kiwis = m.addVar(vtype=gp.GRB.INTEGER, name="kiwis")

# Set objective function
m.setObjective(9*hot_dogs + 7*strawberries + 4*apple_pies + 7*peanutbutter_sandwiches + 3*kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*hot_dogs + 25*kiwis >= 130)
m.addConstr(17*strawberries + 25*kiwis >= 73)
m.addConstr(2*hot_dogs + 26*peanutbutter_sandwiches >= 77)
m.addConstr(2*hot_dogs + 17*strawberries >= 104)
m.addConstr(26*peanutbutter_sandwiches + 25*kiwis >= 87)
m.addConstr(15*apple_pies + 26*peanutbutter_sandwiches >= 84)
m.addConstr(17*strawberries + 26*peanutbutter_sandwiches >= 48)
m.addConstr(17*strawberries + 26*peanutbutter_sandwiches + 25*kiwis >= 78)
m.addConstr(2*hot_dogs + 17*strawberries + 15*apple_pies + 26*peanutbutter_sandwiches + 25*kiwis >= 78)
m.addConstr(1*apple_pies + 4*kiwis >= 42)
m.addConstr(8*hot_dogs + 1*apple_pies >= 30)
m.addConstr(12*strawberries + 2*peanutbutter_sandwiches >= 35)
m.addConstr(8*hot_dogs + 2*peanutbutter_sandwiches >= 18)
m.addConstr(8*hot_dogs + 12*strawberries >= 46)
m.addConstr(2*peanutbutter_sandwiches + 4*kiwis >= 51)
m.addConstr(12*strawberries + 4*kiwis >= 32)
m.addConstr(8*hot_dogs + 12*strawberries + 4*kiwis >= 27)
m.addConstr(8*hot_dogs + 12*strawberries + 1*apple_pies + 2*peanutbutter_sandwiches + 4*kiwis >= 27)
m.addConstr(9*strawberries - 3*kiwis >= 0)
m.addConstr(-2*apple_pies + 5*kiwis >= 0)
m.addConstr(2*hot_dogs + 25*kiwis <= 433)
m.addConstr(2*hot_dogs + 26*peanutbutter_sandwiches + 25*kiwis <= 458)
m.addConstr(17*strawberries + 15*apple_pies + 25*kiwis <= 553)
m.addConstr(12*strawberries + 1*apple_pies + 4*kiwis <= 230)

# Resource Constraints
m.addConstr(2*hot_dogs + 17*strawberries + 15*apple_pies + 26*peanutbutter_sandwiches + 25*kiwis <= 662)
m.addConstr(8*hot_dogs + 12*strawberries + 1*apple_pies + 2*peanutbutter_sandwiches + 4*kiwis <= 256)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

