
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hot_dogs", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="apple_pies", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9*x0 + 7*x1 + 4*x2 + 7*x3 + 3*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(2*x0 + 17*x1 + 15*x2 + 26*x3 + 25*x4 <= 662, name="carbohydrates_upper_bound")
m.addConstr(8*x0 + 12*x1 + x2 + 2*x3 + 4*x4 <= 256, name="iron_upper_bound")
m.addConstr(2*x0 + 25*x4 >= 130, name="carbohydrates_hot_dogs_kiwis")
m.addConstr(17*x1 + 25*x4 >= 73, name="carbohydrates_strawberries_kiwis")
m.addConstr(2*x0 + 26*x3 >= 77, name="carbohydrates_hot_dogs_peanutbutter_sandwiches")
m.addConstr(2*x0 + 17*x1 >= 104, name="carbohydrates_hot_dogs_strawberries")
m.addConstr(26*x3 + 25*x4 >= 87, name="carbohydrates_peanutbutter_sandwiches_kiwis")
m.addConstr(15*x2 + 26*x3 >= 84, name="carbohydrates_apple_pies_peanutbutter_sandwiches")
m.addConstr(17*x1 + 26*x3 >= 48, name="carbohydrates_strawberries_peanutbutter_sandwiches")
m.addConstr(17*x1 + 26*x3 + 25*x4 >= 78, name="carbohydrates_strawberries_peanutbutter_sandwiches_kiwis")
m.addConstr(2*x0 + 17*x1 + 15*x2 + 26*x3 + 25*x4 >= 78, name="carbohydrates_all")
m.addConstr(x2 + 4*x4 >= 42, name="iron_apple_pies_kiwis")
m.addConstr(8*x0 + x2 >= 30, name="iron_hot_dogs_apple_pies")
m.addConstr(12*x1 + 2*x3 >= 35, name="iron_strawberries_peanutbutter_sandwiches")
m.addConstr(8*x0 + 2*x3 >= 18, name="iron_hot_dogs_peanutbutter_sandwiches")
m.addConstr(8*x0 + 12*x1 >= 46, name="iron_hot_dogs_strawberries")
m.addConstr(2*x3 + 4*x4 >= 51, name="iron_peanutbutter_sandwiches_kiwis")
m.addConstr(12*x1 + 4*x4 >= 32, name="iron_strawberries_kiwis")
m.addConstr(8*x0 + 12*x1 + 4*x4 >= 27, name="iron_hot_dogs_strawberries_kiwis")
m.addConstr(8*x0 + 12*x1 + x2 + 2*x3 + 4*x4 >= 27, name="iron_all")
m.addConstr(9*x1 - 3*x4 >= 0, name="strawberries_kiwis_constraint")
m.addConstr(-2*x2 + 5*x4 >= 0, name="apple_pies_kiwis_constraint")
m.addConstr(2*x0 + 25*x4 <= 433, name="carbohydrates_hot_dogs_kiwis_upper_bound")
m.addConstr(2*x0 + 26*x3 + 25*x4 <= 458, name="carbohydrates_hot_dogs_peanutbutter_sandwiches_kiwis_upper_bound")
m.addConstr(17*x1 + 15*x2 + 25*x4 <= 553, name="carbohydrates_strawberries_apple_pies_kiwis_upper_bound")
m.addConstr(12*x1 + x2 + 4*x4 <= 230, name="iron_strawberries_apple_pies_kiwis_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hot dogs: ", x0.varValue)
    print("Strawberries: ", x1.varValue)
    print("Apple pies: ", x2.varValue)
    print("Peanutbutter sandwiches: ", x3.varValue)
    print("Kiwis: ", x4.varValue)
else:
    print("The model is infeasible")
