
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
protein_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein_bars")
sashimi = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")


# Set objective function
m.setObjective(4.12 * oranges + 5.22 * granola_bars + 7.71 * protein_bars + 1.9 * sashimi, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * granola_bars + 15 * protein_bars >= 55)
m.addConstr(5 * oranges + 7 * granola_bars >= 57)
m.addConstr(15 * protein_bars + 13 * sashimi >= 26)
m.addConstr(7 * granola_bars + 15 * protein_bars + 13 * sashimi >= 50)
m.addConstr(5 * oranges + 7 * granola_bars + 15 * protein_bars + 13 * sashimi >= 50)
m.addConstr(7 * protein_bars + 14 * sashimi >= 95)
m.addConstr(17 * oranges + 7 * granola_bars >= 79)
m.addConstr(17 * oranges + 14 * sashimi >= 60)
m.addConstr(7 * granola_bars + 14 * sashimi >= 53)
m.addConstr(17 * oranges + 7 * granola_bars + 14 * sashimi >= 87)
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars >= 87)
m.addConstr(17 * oranges + 7 * granola_bars + 14 * sashimi >= 84)
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars >= 84)
m.addConstr(17 * oranges + 7 * granola_bars + 7 * protein_bars + 14 * sashimi >= 84)
m.addConstr(17 * granola_bars + 7 * sashimi >= 50)
m.addConstr(12 * oranges + 17 * protein_bars >= 66)
m.addConstr(12 * oranges + 17 * granola_bars >= 72)
m.addConstr(12 * oranges + 17 * granola_bars + 17 * protein_bars + 7 * sashimi >= 72)
m.addConstr(5 * granola_bars + 9 * sashimi >= 95)
m.addConstr(8 * oranges + 5 * granola_bars >= 70)
m.addConstr(5 * granola_bars + 9 * protein_bars >= 84)
m.addConstr(8 * oranges + 5 * granola_bars + 9 * protein_bars + 9 * sashimi >= 84)
m.addConstr(5 * oranges + 14 * granola_bars >= 19)
m.addConstr(14 * protein_bars + 4 * sashimi >= 20)
m.addConstr(5 * oranges + 4 * sashimi >= 31)
m.addConstr(14 * granola_bars + 4 * sashimi >= 27)
m.addConstr(5 * oranges + 14 * protein_bars >= 34)
m.addConstr(14 * granola_bars + 14 * protein_bars >= 28)
m.addConstr(5 * oranges + 14 * protein_bars + 4 * sashimi >= 25)
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars >= 25)
m.addConstr(5 * oranges + 14 * protein_bars + 4 * sashimi >= 39)
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars >= 39)
m.addConstr(5 * oranges + 14 * granola_bars + 14 * protein_bars + 4 * sashimi >= 39)
m.addConstr(7 * oranges - 2 * sashimi >= 0)
m.addConstr(15 * protein_bars + 13 * sashimi <= 216)
m.addConstr(7 * granola_bars + 13 * sashimi <= 158)
m.addConstr(7 * granola_bars + 7 * protein_bars <= 354)
m.addConstr(17 * oranges + 7 * granola_bars + 14 * sashimi <= 379)
m.addConstr(17 * oranges + 7 * protein_bars + 14 * sashimi <= 177)
m.addConstr(12 * oranges + 7 * sashimi <= 169)
m.addConstr(12 * oranges + 17 * protein_bars + 7 * sashimi <= 129)
m.addConstr(8 * oranges + 9 * sashimi <= 135)
m.addConstr(5 * granola_bars + 9 * protein_bars <= 338)


# Resource Constraints
resources = {'r0': {'upper_bound': 233, 'x0': 5, 'x1': 7, 'x2': 15, 'x3': 13}, 
            'r1': {'upper_bound': 389, 'x0': 17, 'x1': 7, 'x2': 7, 'x3': 14}, 
            'r2': {'upper_bound': 404, 'x0': 12, 'x1': 17, 'x2': 17, 'x3': 7}, 
            'r3': {'upper_bound': 420, 'x0': 8, 'x1': 5, 'x2': 9, 'x3': 9}, 
            'r4': {'upper_bound': 175, 'x0': 5, 'x1': 14, 'x2': 14, 'x3': 4}}
variables = [oranges, granola_bars, protein_bars, sashimi]

for resource, data in resources.items():
    m.addConstr(data['x0'] * oranges + data['x1'] * granola_bars + data['x2'] * protein_bars + data['x3'] * sashimi <= data['upper_bound'], name=resource)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

