
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="oranges", lb=0)
x1 = m.addVar(name="granola bars", lb=0)
x2 = m.addVar(name="protein bars", lb=0)
x3 = m.addVar(name="sashimi", lb=0)

# Define the objective function
m.setObjective(4.12 * x0 + 5.22 * x1 + 7.71 * x2 + 1.9 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * x0 + 7 * x1 <= 233, name="sourness_index")
m.addConstr(17 * x0 + 7 * x1 + 7 * x2 + 14 * x3 <= 389, name="umami_index")
m.addConstr(12 * x0 + 17 * x1 + 17 * x2 + 7 * x3 <= 404, name="grams_of_protein")
m.addConstr(8 * x0 + 5 * x1 + 9 * x2 + 9 * x3 <= 420, name="milligrams_of_iron")
m.addConstr(5 * x0 + 14 * x1 + 14 * x2 + 4 * x3 <= 175, name="dollar_cost")

m.addConstr(15 * x2 + 13 * x3 >= 55, name="sourness_index_granola_bars_protein_bars")
m.addConstr(5 * x0 + 7 * x1 >= 57, name="sourness_index_oranges_granola_bars")
m.addConstr(15 * x2 + 13 * x3 >= 26, name="sourness_index_protein_bars_sashimi")
m.addConstr(7 * x1 + 15 * x2 + 13 * x3 >= 50, name="sourness_index_granola_bars_protein_bars_sashimi")
m.addConstr(5 * x0 + 7 * x1 + 15 * x2 + 13 * x3 >= 50, name="sourness_index_all")

m.addConstr(7 * x2 + 14 * x3 >= 95, name="umami_index_protein_bars_sashimi")
m.addConstr(17 * x0 + 7 * x1 >= 79, name="umami_index_oranges_granola_bars")
m.addConstr(17 * x0 + 14 * x3 >= 60, name="umami_index_oranges_sashimi")
m.addConstr(7 * x1 + 14 * x3 >= 53, name="umami_index_granola_bars_sashimi")
m.addConstr(17 * x0 + 7 * x1 + 14 * x3 >= 87, name="umami_index_oranges_granola_bars_sashimi")
m.addConstr(17 * x0 + 7 * x1 + 7 * x2 >= 87, name="umami_index_oranges_granola_bars_protein_bars")

m.addConstr(17 * x1 + 7 * x3 >= 50, name="grams_of_protein_granola_bars_sashimi")
m.addConstr(12 * x0 + 17 * x2 >= 66, name="grams_of_protein_oranges_protein_bars")
m.addConstr(12 * x0 + 17 * x1 >= 72, name="grams_of_protein_oranges_granola_bars")

m.addConstr(5 * x1 + 9 * x3 >= 95, name="milligrams_of_iron_granola_bars_sashimi")
m.addConstr(8 * x0 + 5 * x1 >= 70, name="milligrams_of_iron_oranges_granola_bars")

m.addConstr(5 * x0 + 14 * x1 >= 19, name="dollar_cost_oranges_granola_bars")
m.addConstr(14 * x2 + 4 * x3 >= 20, name="dollar_cost_protein_bars_sashimi")

m.addConstr(7 * x0 - 2 * x3 >= 0, name="oranges_sashimi_constraint")

m.addConstr(15 * x2 + 13 * x3 <= 216, name="sourness_index_protein_bars_sashimi_max")
m.addConstr(7 * x1 + 13 * x3 <= 158, name="sourness_index_granola_bars_sashimi_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Oranges: ", x0.varValue)
    print("Granola Bars: ", x1.varValue)
    print("Protein Bars: ", x2.varValue)
    print("Sashimi: ", x3.varValue)
else:
    print("No optimal solution found")
