
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter sandwiches")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola bars")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken thighs")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")


# Set objective function
m.setObjective(3.35*x0**2 + 8.9*x0*x1 + 1.56*x0*x2 + 9.04*x2*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(21.24*x0 + 6.28*x1 + 6.16*x2 + 4.23*x3 <= 374, "c0")
m.addConstr(21.24*x0**2 + 4.23*x3**2 >= 84, "c1")
m.addConstr(6.16*x2**2 + 4.23*x3**2 >= 87, "c2")
m.addConstr(6.28*x1 + 4.23*x3 >= 89, "c3")
m.addConstr(21.24*x0 + 6.28*x1 + 4.23*x3 >= 57, "c4")
m.addConstr(21.24*x0 + 6.16*x2 + 4.23*x3 >= 57, "c5")
m.addConstr(21.24*x0 + 6.28*x1 + 6.16*x2 >= 57, "c6")
m.addConstr(21.24*x0 + 6.28*x1 + 4.23*x3 >= 79, "c7")
m.addConstr(21.24*x0 + 6.16*x2 + 4.23*x3 >= 79, "c8")
m.addConstr(21.24*x0 + 6.28*x1 + 6.16*x2 >= 79, "c9")
m.addConstr(21.24*x0 + 6.28*x1 + 4.23*x3 >= 71, "c10")
m.addConstr(21.24*x0 + 6.16*x2 + 4.23*x3 >= 71, "c11")
m.addConstr(21.24*x0 + 6.28*x1 + 6.16*x2 >= 71, "c12")
m.addConstr(21.24*x0 + 6.28*x1 + 6.16*x2 + 4.23*x3 >= 71, "c13")
m.addConstr(9*x0**2 - x1**2 >= 0, "c14")
m.addConstr(9*x0 - 3*x2 >= 0, "c15")
m.addConstr(6.16*x2 + 4.23*x3 <= 108, "c16")
m.addConstr(21.24*x0 + 4.23*x3 <= 185, "c17")
m.addConstr(21.24*x0 + 6.16*x2 + 4.23*x3 <= 338, "c18")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

