
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="peanutbutter_sandwiches", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="granola_bars", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x4 = m.addVar(name="pickles", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(3.35 * x1**2 + 8.9 * x1 * x2 + 1.56 * x1 * x3 + 9.04 * x3 * x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(21.24 * x1 + 6.28 * x2 + 6.16 * x3 + 4.23 * x4 <= 374)
m.addConstr(21.24**2 * x1**2 + 4.23**2 * x4**2 >= 84)
m.addConstr(6.16**2 * x3**2 + 4.23**2 * x4**2 >= 87)
m.addConstr(6.28 * x2 + 4.23 * x4 >= 89)
m.addConstr(21.24 * x1 + 6.28 * x2 + 4.23 * x4 >= 57)
m.addConstr(21.24 * x1 + 6.16 * x3 + 4.23 * x4 >= 57)
m.addConstr(21.24 * x1 + 6.28 * x2 + 6.16 * x3 >= 57)
m.addConstr(21.24 * x1 + 6.28 * x2 + 4.23 * x4 >= 79)
m.addConstr(21.24 * x1 + 6.16 * x3 + 4.23 * x4 >= 79)
m.addConstr(21.24 * x1 + 6.28 * x2 + 6.16 * x3 >= 79)
m.addConstr(21.24 * x1 + 6.28 * x2 + 4.23 * x4 >= 71)
m.addConstr(21.24 * x1 + 6.16 * x3 + 4.23 * x4 >= 71)
m.addConstr(21.24 * x1 + 6.28 * x2 + 6.16 * x3 >= 71)
m.addConstr(21.24 * x1 + 6.28 * x2 + 6.16 * x3 + 4.23 * x4 >= 71)
m.addConstr(9 * x1**2 - x2**2 >= 0)
m.addConstr(9 * x1 - 3 * x3 >= 0)
m.addConstr(6.16 * x3 + 4.23 * x4 <= 108)
m.addConstr(21.24 * x1 + 4.23 * x4 <= 185)
m.addConstr(21.24 * x1 + 6.16 * x3 + 4.23 * x4 <= 338)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("peanutbutter sandwiches: ", x1.varValue)
    print("granola bars: ", x2.varValue)
    print("chicken thighs: ", x3.varValue)
    print("pickles: ", x4.varValue)
else:
    print("The model is infeasible")
