
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
chicken = m.addVar(vtype=gp.GRB.INTEGER, name="chicken")
potatoes = m.addVar(vtype=gp.GRB.INTEGER, name="potatoes")
tomatoes = m.addVar(vtype=gp.GRB.INTEGER, name="tomatoes")
milkshakes = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")

# Set objective function
m.setObjective(3.29 * chicken + 7.22 * potatoes + 7.31 * tomatoes + 4.91 * milkshakes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(chicken + 3 * milkshakes >= 28, "calcium_constraint1")
m.addConstr(8 * potatoes + 9 * tomatoes >= 29, "calcium_constraint2")
m.addConstr(chicken + 8 * potatoes + 9 * tomatoes + 3 * milkshakes >= 29, "calcium_constraint3")
m.addConstr(5*chicken + 6*tomatoes >= 31, "iron_constraint1")
m.addConstr(7 * potatoes + 4 * milkshakes >= 33, "iron_constraint2")
m.addConstr(7 * potatoes + 6 * tomatoes >= 26, "iron_constraint3")
m.addConstr(5 * chicken + 7 * potatoes + 6 * tomatoes + 4 * milkshakes >= 26, "iron_constraint4")
m.addConstr(potatoes + tomatoes >= 41, "fiber_constraint1")
m.addConstr(3 * chicken + tomatoes >= 38, "fiber_constraint2")
m.addConstr(tomatoes + 8 * milkshakes >= 18, "fiber_constraint3")
m.addConstr(3 * chicken + tomatoes + 8 * milkshakes >= 39, "fiber_constraint4")
m.addConstr(potatoes + tomatoes + 8 * milkshakes >= 39, "fiber_constraint5")
m.addConstr(3 * chicken + tomatoes + 8 * milkshakes >= 22, "fiber_constraint6")
m.addConstr(potatoes + tomatoes + 8 * milkshakes >= 22, "fiber_constraint7")
m.addConstr(3 * chicken + potatoes + tomatoes + 8 * milkshakes >= 22, "fiber_constraint8")
m.addConstr(5 * chicken + 7 * potatoes <= 139, "iron_constraint5")
m.addConstr(7 * potatoes + 4 * milkshakes <= 108, "iron_constraint6")
m.addConstr(5 * chicken + 4 * milkshakes <= 85, "iron_constraint7")
m.addConstr(7 * potatoes + 6 * tomatoes <= 139, "iron_constraint8")
m.addConstr(5 * chicken + 7 * potatoes + 6 * tomatoes + 4 * milkshakes <= 159, "iron_constraint9")
m.addConstr(5 * chicken + 7 * potatoes + 4 * milkshakes <= 61, "iron_constraint10")
m.addConstr(5 * chicken + 7 * potatoes + 6 * tomatoes <= 54, "iron_constraint11")
m.addConstr(3 * chicken + 8 * milkshakes <= 126, "fiber_constraint9")
m.addConstr(potatoes + 8 * milkshakes <= 161, "fiber_constraint10")


# Resource Constraints
m.addConstr(chicken + 8*potatoes + 9*tomatoes + 3*milkshakes <= 120, "calcium_limit")
m.addConstr(5*chicken + 7*potatoes + 6*tomatoes + 4*milkshakes <= 160, "iron_limit")
m.addConstr(3*chicken + potatoes + tomatoes + 8*milkshakes <= 165, "fiber_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chicken:', chicken.x)
    print('potatoes:', potatoes.x)
    print('tomatoes:', tomatoes.x)
    print('milkshakes:', milkshakes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

