
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="chicken_breasts", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="potatoes", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="tomatoes", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="milkshakes", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(3.29*x0 + 7.22*x1 + 7.31*x2 + 4.91*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x0 + 8*x1 + 9*x2 + 3*x3 <= 120)
    model.addConstr(5*x0 + 7*x1 + 6*x2 + 4*x3 <= 160)
    model.addConstr(3*x0 + x1 + x2 + 8*x3 <= 165)
    model.addConstr(x0 + x3 >= 28)
    model.addConstr(x1 + x2 >= 29)
    model.addConstr(x0 + x1 + x2 + x3 >= 29)
    model.addConstr(5*x0 + 6*x2 >= 31)
    model.addConstr(7*x1 + 4*x3 >= 33)
    model.addConstr(7*x1 + 6*x2 >= 26)
    model.addConstr(5*x0 + 7*x1 + 6*x2 + 4*x3 >= 26)
    model.addConstr(x1 + x2 >= 41)
    model.addConstr(3*x0 + x2 >= 38)
    model.addConstr(x2 + 8*x3 >= 18)
    model.addConstr(3*x0 + x2 + 8*x3 >= 39)
    model.addConstr(x1 + x2 + 8*x3 >= 39)
    model.addConstr(3*x0 + x1 + x2 + 8*x3 >= 22)
    model.addConstr(5*x0 + 7*x1 <= 139)
    model.addConstr(7*x1 + 4*x3 <= 108)
    model.addConstr(5*x0 + 4*x3 <= 85)
    model.addConstr(7*x1 + 6*x2 <= 139)
    model.addConstr(5*x0 + 6*x2 + 4*x3 <= 159)
    model.addConstr(5*x0 + 7*x1 + 4*x3 <= 61)
    model.addConstr(5*x0 + 7*x1 + 6*x2 <= 54)
    model.addConstr(3*x0 + 8*x3 <= 126)
    model.addConstr(x1 + 8*x3 <= 161)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chicken breasts: ", x0.varValue)
        print("Potatoes: ", x1.varValue)
        print("Tomatoes: ", x2.varValue)
        print("Milkshakes: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
