
import gurobipy as gp

# Create a new model
model = gp.Model("minimize_cost")

# Create variables
bill_hours = model.addVar(name="bill_hours")
bobby_hours = model.addVar(name="bobby_hours")

# Set objective function
model.setObjective(4.11 * bill_hours + 4.49 * bobby_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * bill_hours + 9 * bobby_hours >= 38, "dollar_cost_min")
model.addConstr(1 * bill_hours + 3 * bobby_hours >= 46, "quit_index_min")
model.addConstr(-2 * bill_hours + 2 * bobby_hours >= 0, "bill_bobby_relation")
model.addConstr(4 * bill_hours + 9 * bobby_hours <= 87, "dollar_cost_max")
model.addConstr(1 * bill_hours + 3 * bobby_hours <= 94, "quit_index_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution:")
    print(f"Hours worked by Bill: {bill_hours.x}")
    print(f"Hours worked by Bobby: {bobby_hours.x}")
    print(f"Objective value: {model.objVal}")

