
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(4.11*x1 + 4.49*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(4*x1 + 9*x2 >= 38, "dollar_cost_min")
m.addConstr(x1 + 3*x2 >= 46, "quit_index_min")
m.addConstr(-2*x1 + 2*x2 >= 0, "hours_balance")
m.addConstr(4*x1 + 9*x2 <= 87, "dollar_cost_max")
m.addConstr(x1 + 3*x2 <= 94, "quit_index_max")

# Optimize the model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {x1.x}")
    print(f"Hours worked by Bobby: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
