
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Bill", lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative

    # Define objective function
    model.setObjective(4.11 * x1 + 4.49 * x2, gurobi.GRB.MINIMIZE)

    # Define constraints
    model.addConstr(4 * x1 + 9 * x2 >= 38)
    model.addConstr(x1 + 3 * x2 >= 46)
    model.addConstr(-2 * x1 + 2 * x2 >= 0)
    model.addConstr(4 * x1 + 9 * x2 <= 87)
    model.addConstr(x1 + 3 * x2 <= 94)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
