
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin K
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # grams of fiber


    # Set objective function
    m.setObjective(7*x0*x1 + 8*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*x0 + 14*x1 >= 12, "c0")
    m.addConstr(5*x0 + 15*x1 >= 16, "c1")
    m.addConstr(7*x0*x0 + 2*x1*x1 >= 30, "c2")
    m.addConstr(17*x0*x0 + 8*x1*x1 >= 18, "c3")
    m.addConstr(-3*x0 + 5*x1 >= 0, "c4")
    m.addConstr(10*x0*x0 + 14*x1*x1 <= 31, "c5")
    m.addConstr(5*x0 + 15*x1 <= 19, "c6")
    m.addConstr(7*x0*x0 + 2*x1*x1 <= 76, "c7")
    m.addConstr(17*x0 + 8*x1 <= 41, "c8")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
