
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams_of_vitamin_K", lb=0)  # Assuming non-negative
x2 = m.addVar(name="grams_of_fiber", lb=0)  # Assuming non-negative

# Define the objective function
m.setObjective(7 * x1 * x2 + 8 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * x1 <= 42)
m.addConstr(5 * x1 <= 34)
m.addConstr(7 * x1 <= 99)
m.addConstr(17 * x1 <= 42)
m.addConstr(14 * x2 <= 42)
m.addConstr(15 * x2 <= 34)
m.addConstr(2 * x2 <= 99)
m.addConstr(8 * x2 <= 42)
m.addConstr(10 * x1 + 14 * x2 >= 12)
m.addConstr(5 * x1 + 15 * x2 >= 16)
m.addConstr(7 * x1**2 + 2 * x2**2 >= 30)
m.addConstr(17 * x1**2 + 8 * x2**2 >= 18)
m.addConstr(-3 * x1 + 5 * x2 >= 0)
m.addConstr(10 * x1**2 + 14 * x2**2 <= 31)
m.addConstr(5 * x1 + 15 * x2 <= 19)
m.addConstr(7 * x1**2 + 2 * x2**2 <= 76)
m.addConstr(17 * x1 + 8 * x2 <= 41)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin K: {x1.varValue}")
    print(f"Grams of fiber: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
