
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # grams of protein
x1 = m.addVar(name="x1", lb=0)  # milligrams of potassium
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin B4
x3 = m.addVar(name="x3", lb=0)  # milligrams of vitamin B3

# Objective function
m.setObjective(8.14 * x0 + 4.73 * x1 + 7.96 * x2 + 3.19 * x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(6 * x0 <= 693)
m.addConstr(5 * x0 <= 670)
m.addConstr(28 * x0 <= 610)
m.addConstr(28 * x1 <= 693)
m.addConstr(4 * x1 <= 670)
m.addConstr(26 * x1 <= 610)
m.addConstr(x2 <= 693)
m.addConstr(9 * x2 <= 670)
m.addConstr(26 * x2 <= 610)
m.addConstr(22 * x3 <= 693)
m.addConstr(8 * x3 <= 670)
m.addConstr(12 * x3 <= 610)
m.addConstr(6 * x0 + 22 * x3 >= 127)
m.addConstr(6 * x0 + 28 * x1 >= 104)
m.addConstr(28 * x1 + 22 * x3 >= 147)
m.addConstr(x2 + 22 * x3 >= 167)
m.addConstr(6 * x0 + 28 * x1 + 22 * x3 >= 111)
m.addConstr(6 * x0 + 28 * x1 + x2 + 22 * x3 >= 111)
m.addConstr(5 * x0 + 9 * x2 >= 91)
m.addConstr(5 * x0 + 8 * x3 >= 71)
m.addConstr(4 * x1 + 9 * x2 >= 114)
m.addConstr(5 * x0 + 4 * x1 + 9 * x2 + 8 * x3 >= 114)
m.addConstr(28 * x0 + 12 * x3 >= 121)
m.addConstr(28 * x0 + 26 * x2 >= 68)
m.addConstr(26 * x2 + 12 * x3 >= 108)
m.addConstr(28 * x0 + 26 * x1 >= 120)
m.addConstr(26 * x1 + 12 * x3 >= 108)
m.addConstr(28 * x0 + 26 * x1 + 12 * x3 >= 108)
m.addConstr(28 * x0 + 26 * x2 + 12 * x3 >= 108)
m.addConstr(28 * x0 + 26 * x1 + 12 * x3 >= 146)
m.addConstr(28 * x0 + 26 * x2 + 12 * x3 >= 146)
m.addConstr(28 * x0 + 26 * x1 + 26 * x2 + 12 * x3 >= 146)
m.addConstr(x2 - 5 * x3 >= 0)
m.addConstr(x2 + 22 * x3 <= 553)
m.addConstr(28 * x1 + x2 <= 554)
m.addConstr(6 * x0 + 22 * x3 <= 231)
m.addConstr(6 * x0 + 28 * x1 <= 178)
m.addConstr(6 * x0 + 28 * x1 + 22 * x3 <= 508)
m.addConstr(6 * x0 + x2 + 22 * x3 <= 304)
m.addConstr(5 * x0 + 4 * x1 <= 411)
m.addConstr(5 * x0 + 8 * x3 <= 539)
m.addConstr(4 * x1 + 9 * x2 <= 357)
m.addConstr(4 * x1 + 8 * x3 <= 445)
m.addConstr(5 * x0 + 9 * x2 <= 266)
m.addConstr(5 * x0 + 4 * x1 + 8 * x3 <= 459)
m.addConstr(5 * x0 + 9 * x2 + 8 * x3 <= 322)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
