
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="squash_plants")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="zucchini_vines")
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="basil_plants")

    # Set objective function
    m.setObjective(6*x0**2 + 4*x0*x1 + 7*x0*x2 + 7*x0*x3 + 5*x1**2 + 6*x2**2 + 4*x2*x3 + 5*x3**2 + 2*x0 + 9*x1 + 6*x2 + 8*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(0.74*x0 + 0.84*x3 >= 13)
    m.addConstr(0.55*x2 + 0.84*x3 >= 5)
    m.addConstr((0.76*x1)**2 + (0.84*x3)**2 >= 11)
    m.addConstr(0.74*x0 + 0.55*x2 >= 11)
    m.addConstr(0.76*x1 + 0.55*x2 >= 10)
    m.addConstr(-4*x0**2 + 7*x2**2 >= 0)
    m.addConstr(0.34*x1 + 0.46*x3 <= 35)
    m.addConstr(0.7*x0 + 0.18*x2 <= 18)
    m.addConstr(0.7*x0 + 0.46*x3 <= 36)
    m.addConstr((0.7*x0)**2 + (0.34*x1)**2 <= 10)
    m.addConstr(0.7*x0 + 0.34*x1 + 0.18*x2 + 0.46*x3 <= 10)
    m.addConstr(0.76*x1 + 0.55*x2 <= 36)
    m.addConstr(0.74*x0 + 0.55*x2 <= 21)
    m.addConstr(0.76*x1 + 0.84*x3 <= 16)
    m.addConstr(0.74*x0 + 0.76*x1 <= 24)
    m.addConstr(0.74*x0 + 0.84*x3 <= 35)
    m.addConstr(0.74*x0 + 0.76*x1 + 0.55*x2 + 0.84*x3 <= 35)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
