
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    lanyards = model.addVar(vtype=gp.GRB.INTEGER, name="lanyards")
    postage_stamps = model.addVar(vtype=gp.GRB.INTEGER, name="postage_stamps")
    cans_of_coffee = model.addVar(vtype=gp.GRB.INTEGER, name="cans_of_coffee")

    # Set objective function
    model.setObjective(7.8 * lanyards + 3.65 * postage_stamps + 4.87 * cans_of_coffee, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(17 * lanyards + 6 * cans_of_coffee >= 20, "c1")
    model.addConstr(5 * postage_stamps + 6 * cans_of_coffee >= 12, "c2")
    model.addConstr(17 * lanyards + 5 * postage_stamps + 6 * cans_of_coffee >= 20, "c3")
    model.addConstr(12 * lanyards + 8 * cans_of_coffee >= 54, "c4")
    model.addConstr(11 * postage_stamps + 8 * cans_of_coffee >= 52, "c5")
    model.addConstr(12 * lanyards + 11 * postage_stamps + 8 * cans_of_coffee >= 52, "c6")
    model.addConstr(1 * lanyards - 3 * postage_stamps >= 0, "c7")
    model.addConstr(17 * lanyards + 5 * postage_stamps + 6 * cans_of_coffee <= 39, "c8")
    model.addConstr(12 * lanyards + 8 * cans_of_coffee <= 151, "c9")
    model.addConstr(12 * lanyards + 11 * postage_stamps <= 65, "c10")
    model.addConstr(11 * postage_stamps + 8 * cans_of_coffee <= 101, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('lanyards:', lanyards.x)
        print('postage_stamps:', postage_stamps.x)
        print('cans_of_coffee:', cans_of_coffee.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
