
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cans_of_coffee", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7.8*x0 + 3.65*x1 + 4.87*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(17*x0 + 6*x2 >= 20)
    model.addConstr(5*x1 + 6*x2 >= 12)
    model.addConstr(17*x0 + 5*x1 + 6*x2 >= 20)
    model.addConstr(12*x0 + 8*x2 >= 54)
    model.addConstr(11*x1 + 8*x2 >= 52)
    model.addConstr(12*x0 + 11*x1 + 8*x2 >= 52)
    model.addConstr(x0 - 3*x1 >= 0)
    model.addConstr(17*x0 + 5*x1 + 6*x2 <= 39)
    model.addConstr(12*x0 + 8*x2 <= 151)
    model.addConstr(12*x0 + 11*x1 <= 65)
    model.addConstr(11*x1 + 8*x2 <= 101)
    model.addConstr(17*x0 + 5*x1 + 6*x2 <= 79)
    model.addConstr(12*x0 + 11*x1 + 8*x2 <= 163)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Lanyards: ", x0.varValue)
        print("Postage Stamps: ", x1.varValue)
        print("Cans of Coffee: ", x2.varValue)
    else:
        print("No optimal solution found")

solve_optimization_problem()
