
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
strawberries = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strawberries")
fruit_salads = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
potatoes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="potatoes")
cherry_pies = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cherry_pies")

# Set objective function
m.setObjective(6*strawberries + 1*fruit_salads + 2*potatoes + 8*cherry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*strawberries + 3*cherry_pies >= 105)
m.addConstr(19*fruit_salads + 3*cherry_pies >= 86)
m.addConstr(7*strawberries + 11*potatoes >= 63)
m.addConstr(7*strawberries + 19*fruit_salads >= 75)
m.addConstr(7*strawberries + 19*fruit_salads + 3*cherry_pies >= 55)
m.addConstr(7*strawberries + 11*potatoes + 3*cherry_pies >= 55)
m.addConstr(7*strawberries + 19*fruit_salads + 3*cherry_pies >= 68)
m.addConstr(7*strawberries + 11*potatoes + 3*cherry_pies >= 68)
m.addConstr(7*strawberries + 19*fruit_salads + 11*potatoes + 3*cherry_pies >= 68)
m.addConstr(24*fruit_salads + 21*potatoes >= 22)
m.addConstr(24*fruit_salads + 12*cherry_pies >= 24)
m.addConstr(10*strawberries + 21*potatoes >= 37)
m.addConstr(10*strawberries + 24*fruit_salads + 21*potatoes + 12*cherry_pies >= 37)
m.addConstr(25*strawberries + 28*cherry_pies >= 59)
m.addConstr(11*fruit_salads + 28*cherry_pies >= 50)
m.addConstr(2*potatoes + 28*cherry_pies >= 54)
m.addConstr(25*strawberries + 11*fruit_salads + 28*cherry_pies >= 60)
m.addConstr(11*fruit_salads + 2*potatoes + 28*cherry_pies >= 60)
m.addConstr(25*strawberries + 11*fruit_salads + 2*potatoes >= 60)
m.addConstr(25*strawberries + 11*fruit_salads + 28*cherry_pies >= 50)
m.addConstr(11*fruit_salads + 2*potatoes + 28*cherry_pies >= 50)
m.addConstr(25*strawberries + 11*fruit_salads + 2*potatoes >= 50)
m.addConstr(25*strawberries + 11*fruit_salads + 28*cherry_pies >= 93)
m.addConstr(11*fruit_salads + 2*potatoes + 28*cherry_pies >= 93)
m.addConstr(25*strawberries + 11*fruit_salads + 2*potatoes >= 93)
m.addConstr(25*strawberries + 11*fruit_salads + 2*potatoes + 28*cherry_pies >= 93)
m.addConstr(27*fruit_salads + 16*potatoes >= 44)
m.addConstr(7*strawberries + 29*cherry_pies >= 26)
m.addConstr(27*fruit_salads + 29*cherry_pies >= 33)
m.addConstr(27*fruit_salads + 16*potatoes + 29*cherry_pies >= 31)
m.addConstr(7*strawberries + 27*fruit_salads + 16*potatoes + 29*cherry_pies >= 31)
m.addConstr(9*strawberries - 9*potatoes >= 0)
m.addConstr(5*fruit_salads - 10*cherry_pies >= 0)
m.addConstr(8*strawberries - 6*cherry_pies >= 0)
m.addConstr(25*strawberries + 2*potatoes <= 314)
m.addConstr(11*fruit_salads + 28*cherry_pies <= 318)
m.addConstr(2*potatoes + 28*cherry_pies <= 104)
m.addConstr(16*potatoes + 29*cherry_pies <= 117)
m.addConstr(27*fruit_salads + 16*potatoes <= 157)

# Resource Constraints
m.addConstr(7*strawberries + 19*fruit_salads + 11*potatoes + 3*cherry_pies <= 443)
m.addConstr(10*strawberries + 24*fruit_salads + 21*potatoes + 12*cherry_pies <= 165)
m.addConstr(25*strawberries + 11*fruit_salads + 2*potatoes + 28*cherry_pies <= 372)
m.addConstr(7*strawberries + 27*fruit_salads + 16*potatoes + 29*cherry_pies <= 213)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

