
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="strawberries", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="fruit_salads", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="potatoes", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="cherry_pies", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(6 * x0 + x1 + 2 * x2 + 8 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * x0 + 3 * x3 >= 105)
m.addConstr(19 * x1 + 3 * x3 >= 86)
m.addConstr(7 * x0 + 11 * x2 >= 63)
m.addConstr(7 * x0 + 19 * x1 >= 75)
m.addConstr(7 * x0 + 19 * x1 + 3 * x3 >= 55)
m.addConstr(7 * x0 + 11 * x2 + 3 * x3 >= 55)
m.addConstr(7 * x0 + 19 * x1 + 3 * x3 >= 68)
m.addConstr(7 * x0 + 11 * x2 + 3 * x3 >= 68)
m.addConstr(7 * x0 + 19 * x1 + 11 * x2 + 3 * x3 >= 68)
m.addConstr(24 * x1 + 21 * x2 >= 22)
m.addConstr(24 * x1 + 12 * x3 >= 24)
m.addConstr(10 * x0 + 21 * x2 >= 37)
m.addConstr(10 * x0 + 24 * x1 + 21 * x2 + 12 * x3 >= 37)
m.addConstr(25 * x0 + 28 * x3 >= 59)
m.addConstr(11 * x1 + 28 * x3 >= 50)
m.addConstr(2 * x2 + 28 * x3 >= 54)
m.addConstr(25 * x0 + 11 * x1 + 28 * x3 >= 60)
m.addConstr(11 * x1 + 2 * x2 + 28 * x3 >= 60)
m.addConstr(25 * x0 + 11 * x1 + 2 * x2 >= 60)
m.addConstr(25 * x0 + 11 * x1 + 28 * x3 >= 50)
m.addConstr(11 * x1 + 2 * x2 + 28 * x3 >= 50)
m.addConstr(25 * x0 + 11 * x1 + 2 * x2 >= 50)
m.addConstr(25 * x0 + 11 * x1 + 28 * x3 >= 93)
m.addConstr(11 * x1 + 2 * x2 + 28 * x3 >= 93)
m.addConstr(25 * x0 + 2 * x2 >= 93)
m.addConstr(25 * x0 + 11 * x1 + 2 * x2 + 28 * x3 >= 93)
m.addConstr(27 * x1 + 16 * x2 >= 44)
m.addConstr(7 * x0 + 29 * x3 >= 26)
m.addConstr(27 * x1 + 29 * x3 >= 33)
m.addConstr(27 * x1 + 16 * x2 + 29 * x3 >= 31)
m.addConstr(7 * x0 + 27 * x1 + 16 * x2 + 29 * x3 >= 31)
m.addConstr(9 * x0 - 9 * x2 >= 0)
m.addConstr(5 * x1 - 10 * x3 >= 0)
m.addConstr(8 * x0 - 6 * x3 >= 0)
m.addConstr(25 * x0 + 2 * x2 <= 314)
m.addConstr(11 * x1 + 28 * x3 <= 318)
m.addConstr(2 * x2 + 28 * x3 <= 104)
m.addConstr(16 * x2 + 29 * x3 <= 117)
m.addConstr(27 * x1 + 16 * x2 <= 157)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Strawberries: ", x0.varValue)
    print("Fruit Salads: ", x1.varValue)
    print("Potatoes: ", x2.varValue)
    print("Cherry Pies: ", x3.varValue)
else:
    print("The model is infeasible")
