
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x0 = m.addVar(type=gp.GRB.CONTINUOUS, name="x0")  # milligrams of vitamin B4
x1 = m.addVar(type=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B3
x2 = m.addVar(type=gp.GRB.INTEGER, name="x2")  # milligrams of vitamin B1
x3 = m.addVar(type=gp.GRB.CONTINUOUS, name="x3")  # milligrams of vitamin B5
x4 = m.addVar(type=gp.GRB.CONTINUOUS, name="x4")  # milligrams of vitamin B12


# Set objective function
m.setObjective(8*x0**2 + 7*x0*x1 + 4*x0*x2 + x1*x4 + 8*x2*x3 + x3*x4 + 6*x4**2 + 8*x2, gp.GRB.MINIMIZE)

# Add constraints
constraints_data = {
    'r0': {'upper_bound': 204, 'x0': 13, 'x1': 17, 'x2': 1, 'x3': 6, 'x4': 7},
    'r1': {'upper_bound': 199, 'x0': 8, 'x1': 8, 'x2': 13, 'x3': 8, 'x4': 15},
    'r2': {'upper_bound': 268, 'x0': 9, 'x1': 11, 'x2': 19, 'x3': 10, 'x4': 17},
    'r3': {'upper_bound': 241, 'x0': 21, 'x1': 23, 'x2': 3, 'x3': 7, 'x4': 12}
}

for var, resource_data in constraints_data.items():
    m.addConstr(resource_data['x0'] * x0 + resource_data['x1'] * x1 + resource_data['x2'] * x2 + resource_data['x3'] * x3 + resource_data['x4'] * x4 <= resource_data['upper_bound'], name=f"{var}_upper_bound")


with open('constraints.txt', 'r') as f:
    for line in f:
        m.addConstr(eval(line))


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

