
import gurobi as gp

# Define the model
model = gp.Model()

# Define the variables
x0 = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="x0")
x1 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="x1", vtype=gp.GRB.INTEGER)
x2 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="x2", vtype=gp.GRB.INTEGER)
x3 = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="x3")
x4 = model.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="x4")

# Objective function
model.setObjective(8*x0**2 + 7*x0*x1 + 4*x0*x2 + x1*x4 + 8*x2*x3 + x3*x4 + 6*x4**2 + 8*x2, gp.GRB.MINIMIZE)

# Constraints
# Add all constraints here...
model.addConstr(13*x0 <= 204)
model.addConstr(8*x0 <= 199)
model.addConstr(9*x0 <= 268)
model.addConstr(21*x0 <= 241)
model.addConstr(17*x1 <= 204)
model.addConstr(8*x1 <= 199)
model.addConstr(11*x1 <= 268)
model.addConstr(23*x1 <= 241)
model.addConstr(x2 <= 204)
model.addConstr(13*x2 <= 199)
model.addConstr(19*x2 <= 268)
model.addConstr(3*x2 <= 241)
model.addConstr(6*x3 <= 204)
model.addConstr(8*x3 <= 199)
model.addConstr(10*x3 <= 268)
model.addConstr(7*x3 <= 241)
model.addConstr(7*x4 <= 204)
model.addConstr(15*x4 <= 199)
model.addConstr(17*x4 <= 268)
model.addConstr(12*x4 <= 241)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print("x0:", x0.varValue)
    print("x1:", x1.varValue)
    print("x2:", x2.varValue)
    print("x3:", x3.varValue)
    print("x4:", x4.varValue)
    print("Objective:", model.objVal)
else:
    print("No optimal solution found.")
