
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="orange_trees")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="basil_plants")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="apple_trees")


    # Set objective function
    m.setObjective(9*x0 + 8*x1 + 3*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 17*x1 + 12*x2 >= 38, "c1")
    m.addConstr(7*x0 + 12*x2 <= 162, "c2")
    m.addConstr(7*x0 + 17*x1 <= 78, "c3")
    m.addConstr(17*x1 + 12*x2 <= 131, "c4")
    m.addConstr(7*x0 + 17*x1 + 12*x2 <= 131, "c5")
    m.addConstr(7*x0 + 16*x1 <= 218, "c6")
    m.addConstr(16*x1 + 13*x2 <= 205, "c7")
    m.addConstr(7*x0 + 16*x1 + 13*x2 <= 205, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

