
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='orange_trees', vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name='basil_plants', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='apple_trees', vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(9 * x0 + 8 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * x0 + 17 * x1 + 12 * x2 >= 38)
    model.addConstr(7 * x0 + 12 * x2 <= 162)
    model.addConstr(7 * x0 + 17 * x1 <= 78)
    model.addConstr(17 * x1 + 12 * x2 <= 131)
    model.addConstr(7 * x0 + 17 * x1 + 12 * x2 <= 131)
    model.addConstr(7 * x0 + 16 * x1 <= 218)
    model.addConstr(16 * x1 + 13 * x2 <= 205)
    model.addConstr(7 * x0 + 16 * x1 + 13 * x2 <= 205)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Orange Trees: ', x0.varValue)
        print('Basil Plants: ', x1.varValue)
        print('Apple Trees: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
