
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")

    # Set objective function
    m.setObjective(7 * vitamin_e + 5 * vitamin_c, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_e + 2 * vitamin_c >= 34, "cardio_support_min")
    m.addConstr(3 * vitamin_e + 7 * vitamin_c >= 11, "muscle_growth_min")
    m.addConstr(6 * vitamin_e - 4 * vitamin_c >= 0, "vitamin_ratio")
    m.addConstr(2 * vitamin_e + 2 * vitamin_c <= 72, "cardio_support_max")  # Redundant given r0
    m.addConstr(3 * vitamin_e + 7 * vitamin_c <= 27, "muscle_growth_max")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective value: %g' % m.objVal)
        print('Vitamin E: %g' % vitamin_e.x)
        print('Vitamin C: %g' % vitamin_c.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    elif m.status == gp.GRB.UNBOUNDED:
        print('Model is unbounded')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

