
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_E", lb=0)  # Vitamin E
    x2 = model.addVar(name="milligrams_of_vitamin_C", lb=0)  # Vitamin C

    # Objective function: Minimize 7*x1 + 5*x2
    model.setObjective(7 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x1 <= 97)
    model.addConstr(3 * x1 <= 29)
    model.addConstr(2 * x2 <= 97)
    model.addConstr(7 * x2 <= 29)
    model.addConstr(2 * x1 + 2 * x2 >= 34)
    model.addConstr(3 * x1 + 7 * x2 >= 11)
    model.addConstr(6 * x1 - 4 * x2 >= 0)
    model.addConstr(2 * x1 + 2 * x2 <= 72)
    model.addConstr(3 * x1 + 7 * x2 <= 27)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
