
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
mary_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="dale_hours")


# Set objective function
m.setObjective(6*hank_hours**2 + 6*hank_hours*peggy_hours + 9*hank_hours*mary_hours + 2*peggy_hours**2 + 4*peggy_hours*mary_hours + 9*peggy_hours*dale_hours + 5*dale_hours**2 + 7*hank_hours + 7*peggy_hours + 7*mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.91*mary_hours**2 + 5.28*dale_hours**2 >= 18)
m.addConstr(7.78*hank_hours + 5.28*dale_hours >= 49)
m.addConstr(7.78*hank_hours**2 + 2.91*mary_hours**2 + 5.28*dale_hours**2 >= 31)
m.addConstr(7.78*hank_hours + 4.57*peggy_hours + 5.28*dale_hours >= 31)
m.addConstr(7.78*hank_hours + 2.91*mary_hours + 5.28*dale_hours >= 27)
m.addConstr(7.78*hank_hours + 4.57*peggy_hours + 5.28*dale_hours >= 27)
m.addConstr(7.7*hank_hours**2 + 8.32*peggy_hours**2 >= 43)
m.addConstr(8.32*peggy_hours + 8.37*dale_hours >= 17)
m.addConstr(6.3*mary_hours + 8.37*dale_hours >= 29)
m.addConstr(7.7*hank_hours + 6.3*mary_hours >= 32)
m.addConstr(8.32*peggy_hours**2 + 6.3*mary_hours**2 >= 25)
m.addConstr(8.32*peggy_hours + 6.3*mary_hours + 8.37*dale_hours >= 41)
m.addConstr(7.7*hank_hours + 8.32*peggy_hours + 8.37*dale_hours >= 41)
m.addConstr(7.7*hank_hours + 6.3*mary_hours + 8.37*dale_hours >= 41)
m.addConstr(8.32*peggy_hours + 6.3*mary_hours + 8.37*dale_hours >= 33)
m.addConstr(7.7*hank_hours**2 + 8.32*peggy_hours**2 + 8.37*dale_hours**2 >= 33)
m.addConstr(7.7*hank_hours + 6.3*mary_hours + 8.37*dale_hours >= 33)
m.addConstr(8.32*peggy_hours**2 + 6.3*mary_hours**2 + 8.37*dale_hours**2 >= 33)
m.addConstr(7.7*hank_hours + 8.32*peggy_hours + 8.37*dale_hours >= 33)
m.addConstr(7.7*hank_hours + 6.3*mary_hours + 8.37*dale_hours >= 33)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

